<?php

namespace App\Imports;

use App\Models\Course;
use App\Models\TrainingField;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithUpserts;

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class CourseImport implements ToModel, WithStartRow
{
    
    public function model(array $row)
    {
        if (!isset($row[0])) {
            return null;
        }
        
        $field = TrainingField::where('name_ar', $row[3])->first();
        $course = Course::where('code',$row[0])->first();
        
        if($course) {
            $course->update([
                'name_ar' => $row[1],
                'name_en' => $row[2],
                'training_field_id' => $field ? $field->id : null,
                'text_ar' => $row[4],
                'text_en' => $row[5],
                'created_by' => auth()->user()->id,
            ]);
        } else {
            return new Course([
               'code' => $row[0],
                'name_ar' => $row[1],
                'name_en' => $row[2],
                'training_field_id' => $field ? $field->id : null,
                'text_ar' => $row[4],
                'text_en' => $row[5],
                'status' => 1,
                'created_by' => auth()->user()->id,
            ]);
        }
    }
    
    
    public function startRow(): int
    {
        return 2;
    }

}

