<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\WhyChooseUs;
use DB;
use File;
use Image;
use App\Helpers\Helper;

class WhyChooseUsController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:whyChooseUs');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function editWhyChooseUs()
    {
        $whyChooseUs = WhyChooseUs::first();
        return view('admin.whyChooseUs.editWhyChooseUs',compact('whyChooseUs'));
    }

    public function update(Request $request)
    {
        $add = WhyChooseUs::first();
        if(!$add) {
            $add = new WhyChooseUs();
        }
        $add->title_en = $request->title_en;
        $add->text_en = $request->text_en;
        $add->title_ar = $request->title_ar;
        $add->text_ar = $request->text_ar;
        $add->alt_img = $request->alt_img;
        $add->alt_banner = $request->alt_banner;
        $add->why_us_title_en = $request->why_us_title_en ;
        $add->why_us_title_ar = $request->why_us_title_ar ;
        $add->why_us_text_en = $request->why_us_text_en ;
        $add->why_us_text_ar = $request->why_us_text_ar ;
        if($add->image && $request->image){
            $add->image = Helper::updateUploadedImage('whyChooseUsStruct',$request->image ,$add->image);
        }elseif($request->image){
            $add->image = Helper::uploadImage('whyChooseUsStruct',$request->image);
        } 
        
        if($add->banner && $request->banner){
            $add->banner = Helper::updateUploadedImage('whyChooseUsStruct',$request->banner ,$add->banner);
        }elseif($request->banner){
            $add->banner = Helper::uploadImage('whyChooseUsStruct',$request->banner);
        } 
        $add->save();
        
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return back();
    }
}
