<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Models\CartCourse;
use App\Models\Certificate;
use App\Models\Course;
use App\Models\Training;
use App\Models\Event;
use App\Models\Exame;
use App\Models\Lesson;
use App\Models\LessonHistory;
use App\Models\OrderCourse;
use App\Models\Order;
use App\Models\PaymentMethod;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\User;
use App\Models\Cart;
use App\Models\GuestCart;
use App\Models\GuestCartCourse;
use App\Models\Wishlist;
use App\Models\GuestWishlist;
use App\Models\ExameUserAnswer;
use App\Models\ExameUserResult;
use App\Models\NotificationUser;
use Auth;
use Image;
use File;
use Illuminate\Support\Facades\Hash;

use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Session;

class UserBoardController extends Controller
{

    public function addWishlist(Request $request){
        $course_id = $request->course_id;
        if(Auth::check()){

            $wishCount_old =Wishlist::where('user_id',Auth::user()->id)->count();
            $check=Wishlist::where('course_id',$course_id)->where('user_id',Auth::user()->id)->first();
            if(! $check){
                $add= new Wishlist();
                $add->user_id =Auth::user()->id ;
                $add->course_id=$course_id;
                $add->save();
            }else{
                $check->delete();
            }

            $wishCount =Wishlist::where('user_id',Auth::user()->id)->count();
            $message = ($wishCount_old<$wishCount)?__('home.your_item_added_successfully'):__('home.your_item_removed_successfully');
            return redirect()->back()->with('success', $message);
        }else{
            if(!Session::has('session_id')){
                Session::put('session_id',mt_rand());
            }
            $wishCount_old =GuestWishlist::where('session_id',Session::get('session_id'))->count();
            $check=GuestWishlist::where('course_id',$course_id)->where('session_id',Session::get('session_id'))->first();
            if(! $check){
                $add= new GuestWishlist();
                $add->session_id =Session::get('session_id') ;
                $add->course_id=$course_id;
                $add->save();
            }else{
                $check->delete();
            }

            $wishCount =GuestWishlist::where('session_id',Session::get('session_id'))->count();
            $message = ($wishCount_old<$wishCount)?__('home.your_item_added_successfully'):__('home.your_item_removed_successfully');
            return redirect()->back()->with('success', $message);
        }
    }

    public function addToCart(Request $request){
        $course_id = $request->course_id;
        $course = Training::find($course_id);
        if(Auth::check()){
             /////// CHECK USER CART /////////////////
             $userCart=Cart::where('user_id',Auth::user()->id)->first();
             if(!$userCart){
                 /////create user cart///
                 $cart= new Cart();
                 $cart->user_id=Auth::user()->id;
                 $cart->save();
             }
             $cart = Cart::where('user_id',Auth::user()->id)->first(); 
             $cartCourse=CartCourse::where('course_id',$course_id)->where('cart_id',$cart->id)->first();
             $orderCourse=OrderCourse::where('course_id',$course_id)->where('user_id',Auth::user()->id)->first();
             $old_cartCount = CartCourse::where('cart_id',$cart->id)->count();
 
             if(!$cartCourse&&!$orderCourse){
                 //////ADD CART PRODUCT ////////
                 $add= new CartCourse();
                 $add->cart_id=$cart->id;
                 $add->course_id=$course_id;
                 if($course->discount()){
                     $add->price=$course->last_price();
                     $add->price_before_discount=$course->price;
                 }else{
                     $add->price=$course->price;
                     $add->price_before_discount=$course->price;
                 }
                 $add->save(); 
 
                 /////// update cart info////
                 $cart->total_price+=$course->last_price();
                 $cart->coupon_discount = NULL;
                 $cart->coupon_id = NULL;
                 $cart->save();
            }elseif(!$orderCourse){
                /////// update cart info////
                $cart->total_price-=$cartCourse->course_price();
                $cart->coupon_discount = NULL;
                $cart->coupon_id = NULL;
                $cart->save();
                $cartCourse->delete();
            } 
            $cartCount = CartCourse::where('cart_id',$cart->id)->count();
            $message = ($old_cartCount<$cartCount)?__('home.your_item_added_successfully'):__('home.your_item_removed_successfully');
           
        }else{

            if(!Session::has('session_id')){
                Session::put('session_id',mt_rand());
            }
            $session_id = Session::get('session_id');

            /////// CHECK USER CART /////////////////
            $cart=GuestCart::where('session_id',$session_id)->first();
            if(!$cart){
                /////create user cart///
                $cart= new GuestCart();
                $cart->session_id=$session_id ;
                $cart->save();
            }
            $cartCourse=GuestCartCourse::where('course_id',$course_id)->where('guest_cart_id',$cart->id)->first();
            $old_cartCount = GuestCartCourse::where('guest_cart_id',$cart->id)->count();

            if(!$cartCourse){
                //////ADD CART PRODUCT ////////
                $add= new GuestCartCourse();
                $add->guest_cart_id=$cart->id;
                $add->course_id=$course_id;
                if($course->discount()){
                    $add->price=$course->last_price();
                    $add->price_before_discount=$course->price;
                }else{
                    $add->price=$course->price;
                    $add->price_before_discount=$course->price;
                }
                $add->save(); 

                /////// update cart info////
                $cart->total_price+=$course->last_price();
                $cart->coupon_discount = NULL;
                $cart->coupon_id = NULL;
                $cart->save();
           }else{
               /////// update cart info////
               $cart->total_price-=$cartCourse->course_price();
               $cart->coupon_discount = NULL;
               $cart->coupon_id = NULL;
               $cart->save();
               $cartCourse->delete();
           }

           $cartCount = GuestCartCourse::where('guest_cart_id',$cart->id)->count();
           $message = ($old_cartCount<$cartCount)?__('home.your_item_added_successfully'):__('home.your_item_removed_successfully');
        }

        return response()->json([
            'html' => view('userboard.sideCartCourses', compact('cartCount','cart'))->render(),
            'cartCount'=>$cartCount,
            'text' => $message,
            'type' => 'Success',]);

    }


    public function cartDelete(Request $request){
        if(Auth::check()){
            /////// CHECK USER CART /////////////////
            $cart=Cart::where('user_id',Auth::user()->id)->first();
            $cartCourse=CartCourse::find($request->cart_course_id);

            if($cartCourse){
               $cart->total_price-=$cartCourse->course_price();
               $cart->coupon_discount = NULL;
               $cart->coupon_id = NULL;
               $cart->save();
               $cartCourse->delete();
           }

           $cartCount = CartCourse::where('cart_id',$cart->id)->count();
          
       }else{

           if(!Session::has('session_id')){
               Session::put('session_id',mt_rand());
           }
           $session_id = Session::get('session_id');
           $cart=GuestCart::where('session_id',$session_id)->first();
           $cartCourse=GuestCartCourse::find($request->cart_course_id);
           if($cartCourse){
              $cart->total_price-=$cartCourse->course_price();
              $cart->coupon_discount = NULL;
              $cart->coupon_id = NULL;
              $cart->save();
              $cartCourse->delete();
          }
          $cartCount = GuestCartCourse::where('guest_cart_id',$cart->id)->count();
       }
       return response()->json([
           'html' => view('userboard.sideCartCourses', compact('cartCount','cart'))->render(),
           'cartCount'=>$cartCount,
           'text' => __('home.your_item_removed_successfully'),
           'type' => 'Success',]);
    }
    
    

    public function buyNow(Request $request){
        $course_id = $request->course_id;
        $course = Course::find($course_id);
        $payment_methods = PaymentMethod::where('status',1)->get();
        if(Auth::check()){
             /////// CHECK USER CART /////////////////
             $userCart=Cart::where('user_id',Auth::user()->id)->first();
             if(!$userCart){
                 /////create user cart///
                 $cart= new Cart();
                 $cart->user_id=Auth::user()->id;
                 $cart->save();
             }
             $cart = Cart::where('user_id',Auth::user()->id)->first(); 
             $cartCourse=CartCourse::where('course_id',$course_id)->where('cart_id',$cart->id)->first();
             $orderCourse=OrderCourse::where('course_id',$course_id)->where('user_id',Auth::user()->id)->first();
             if($orderCourse){
                return redirect('user/my-courses');
             }

             $old_cartCount = CartCourse::where('cart_id',$cart->id)->count();
 
             if(!$cartCourse){
                 //////ADD CART PRODUCT ////////
                 $add= new CartCourse();
                 $add->cart_id=$cart->id;
                 $add->course_id=$course_id;
                 if($course->discount()){
                     $add->price=$course->last_price();
                     $add->price_before_discount=$course->price;
                 }else{
                     $add->price=$course->price;
                     $add->price_before_discount=$course->price;
                 }
                 $add->save(); 
 
                 /////// update cart info////
                 $cart->total_price+=$course->last_price();
                 $cart->coupon_discount = NULL;
                 $cart->coupon_id = NULL;
                 $cart->save();
            }
 
            $cartCount = CartCourse::where('cart_id',$cart->id)->count();
            $message = ($old_cartCount<$cartCount)?__('home.your_item_added_successfully'):__('home.your_item_removed_successfully');
           
        }else{

            if(!Session::has('session_id')){
                Session::put('session_id',mt_rand());
            }
            $session_id = Session::get('session_id');

            /////// CHECK USER CART /////////////////
            $cart=GuestCart::where('session_id',$session_id)->first();
            if(!$cart){
                /////create user cart///
                $cart= new GuestCart();
                $cart->session_id=$session_id ;
                $cart->save();
            }
            $cartCourse=GuestCartCourse::where('course_id',$course_id)->where('guest_cart_id',$cart->id)->first();
            $old_cartCount = GuestCartCourse::where('guest_cart_id',$cart->id)->count();

            if(!$cartCourse){
                //////ADD CART PRODUCT ////////
                $add= new GuestCartCourse();
                $add->guest_cart_id=$cart->id;
                $add->course_id=$course_id;
                if($course->discount()){
                    $add->price=$course->last_price();
                    $add->price_before_discount=$course->price;
                }else{
                    $add->price=$course->price;
                    $add->price_before_discount=$course->price;
                }
                $add->save(); 

                /////// update cart info////
                $cart->total_price+=$course->last_price();
                $cart->coupon_discount = NULL;
                $cart->coupon_id = NULL;
                $cart->save();
           }

           $cartCount = GuestCartCourse::where('guest_cart_id',$cart->id)->count();
           $message = ($old_cartCount<$cartCount)?__('home.your_item_added_successfully'):__('home.your_item_removed_successfully');
        }


        
        if(Auth::check()){
            $user = User::with('cart')->where('id',auth()->user()->id)->first();
            $checkout_coupon = $user->cart->coupon_discount;            
            return view('userboard.checkout',compact('user','checkout_coupon','payment_methods'))->with($message);
        }else{
            $cart=GuestCart::with('cart_courses')->where('session_id',Session::get('session_id'))->first();
            $checkout_coupon = $cart->coupon_discount;            
            return view('userboard.guestCheckout',compact('user','checkout_coupon','payment_methods'))->with($message);
        }


        return $request;
    }

    public function cart(){
        if(Auth::check()){
            $cart=Cart::with('cart_courses')->where('user_id',auth()->user()->id)->first();
        }else{
            $cart=GuestCart::with('cart_courses')->where('session_id',Session::get('session_id'))->first();
        }
        Helper::resetCart();
        return view('userboard.shoppingcart',compact('cart'));
    }
    public function wishlist(){
        if(Auth::check()){
            $wishlist=Wishlist::with('course')->where('user_id',auth()->user()->id)->get();
        }else{
            $wishlist=GuestWishlist::with('course')->where('session_id',Session::get('session_id'))->get();
        }
        Helper::resetCart();

        return view('userboard.wishlist',compact('wishlist'));
    }
    public function wishlistDelete(Request $request){
        if(Auth::check()){
            Wishlist::find($request->wishlist_id)->delete();
        }else{
            GuestWishlist::find($request->wishlist_id)->delete();
        }

    }
    public function profile(){
        $user = User::find(auth()->user()->id);
        Helper::resetCart();
        return view('website.student.profile',compact('user'));
    }
    public function settings(){
        $user = User::find(auth()->user()->id);
        return view('website.student.settings',compact('user'));
    }
    public function updateMyAccount(Request $request){
        $request->validate([
            'f_name' => 'string',
            'l_name' => 'string',
            'phone' => 'string',
            'image' => 'image|mimes:jpeg,png,jpg,gif,svg,webp'
        ]);
        $user = User::find(auth()->user()->id);
        $user->f_name = $request->f_name;
        $user->l_name = $request->l_name;
        $user->phone = $request->phone;
        $user->address = $request->address;
        
        
        if ($request->hasFile("image")) {
            
            $file = $request->file("image");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);
            
            $img_path = base_path() . '/uploads/users/source/';
            
            if ($user->image != null) {
                file_exists($img_path.$user->image) ? unlink(sprintf($img_path . '%s', $user->image)):'';
            }
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/users/source/' . $fileName);
            
            Image::make($file->getRealPath())->save($path);
            $user->image = $fileName;
        }
        $user->save();
        return back()->with('success', trans('home.your_item_updated_successfully'));
    }
    public function updateMyAccountPassword(Request $request){
        $request->validate([
            'current_password' => 'required',
            'newPassword' => 'required|min:6|confirmed',
            'newPassword_confirmation' => 'required'
        ]);

        $user = Auth::user();

        // Check if the current password matches the user's password
        if (!Hash::check($request->current_password, $user->password)) {
            return back()->withErrors(['current_password' => 'Current password is incorrect']);
        }

        // Update the user's password
        $user->password = Hash::make($request->newPassword);
        $user->save();
        return back()->with('success', trans('home.your_item_updated_successfully'));
        
    }

    public function dashboard(){
        $user = auth()->user();
        $my_courses = $user->my_courses;
        $my_completed_courses = $user->my_completed_courses;
        return view('website.student.dashboard',compact('my_courses','my_completed_courses'));
    }
    public function myCourses(){
        $user = auth()->user();
        $my_courses = $user->my_courses;
        $my_completed_courses = $user->my_completed_courses;
        return view('website.student.courses',compact('user','my_courses','my_completed_courses'));
    }
    
    public function myOrders(){
        $user = auth()->user();
        $orders = Order::with('orderCourses.course')->where('user_id',$user->id)->get();
        return view('website.student.orders',compact('user','orders'));
    }
    public function myWishlist(){
        $user = auth()->user();
        $wishlist=Wishlist::with(['course','course.category','course.discount'])->where('user_id', $user->id)->get();
        return view('website.student.wishlist',compact('user','wishlist'));
    }
    public function notification(){
        NotificationUser::where('user_id',auth()->user()->id)->update(['seen'=>1]);
        $user = User::with('notifications')->where('id',auth()->user()->id)->first();
        return view('userboard.notification',compact('user'));
    }
    public function myQuizes(){
        $user = auth()->user();
        $my_exames = $user->my_quizes();
        return view('userboard.myQuizes',compact('user','my_exames'));
    }
    public function certificates(){
        $user = auth()->user();
        $courses = OrderCourse::with('course')->where('user_id',auth()->user()->id)->where('progress',100)->get();
        return view('userboard.certificates',compact('user','courses'));
    }
    public function watchCourse($link){
        $user = auth()->user();
        $course = Training::with('course','course.chapters')->where('link_en',$link)->orWhere('link_ar',$link)->firstOrFail();
        $order_course = OrderCourse::where('user_id',$user->id)->where('course_id',$course->id)->firstOrFail();
        if(!$order_course){
            return redirect('/');
        }
        $course_lessons = Lesson::where('course_id',$course->course->id)->orderBy('id')->get();
        $lesson_history = LessonHistory::where('user_id',$user->id)->pluck('lesson_id')->toArray();
        foreach($course_lessons as $course_lesson){
            if(! in_array($course_lesson->id,$lesson_history)){
                $prev_lesson = Lesson::where('course_id',$course_lesson->course_id)->where('order',$course_lesson->order-1)->first();
                $next_lesson = Lesson::where('course_id',$course_lesson->course_id)->where('order',$course_lesson->order+1)->first();
                return view('userboard.lesson_details',compact('user','course_lesson','order_course','course','prev_lesson','next_lesson'));
            }else{
                $chapters = $course->course->chapters->sortBy('order')->values();
                $lesson = $course->course->chapters->first()->lessons->first();

                $currentChapterIndex = $chapters->search(function ($chapter) use ($lesson) {
                    return $chapter->id == $lesson->chapter_id;
                });

                $prev_lesson = Lesson::where('course_id', $lesson->course_id)
                ->where('chapter_id', $course_lesson->chapter_id)
                ->where('order', $lesson->order - 1)
                ->first();
            
                $next_lesson = Lesson::where('course_id', $lesson->course_id)
                    ->where('chapter_id', $course_lesson->chapter_id)
                    ->where('order', $lesson->order + 1)
                    ->first();
            
                // If no previous lesson in the current chapter, find the last lesson of the previous chapter
                if (!$prev_lesson && $currentChapterIndex > 0) {
                    $previousChapter = $chapters[$currentChapterIndex - 1];
                    $prev_lesson = Lesson::where('course_id', $lesson->course_id)
                        ->where('chapter_id', $previousChapter->id)
                        ->orderBy('order', 'desc')
                        ->first();
                }
                if (!$next_lesson && $currentChapterIndex < $chapters->count() - 1) {
                    $previousChapter = $chapters[$currentChapterIndex + 1];
                    $next_lesson = Lesson::where('course_id', $lesson->course_id)
                        ->where('chapter_id', $previousChapter->id)
                        ->orderBy('order', 'asc')
                        ->first();
                }    
            }
            return view('userboard.lesson_details',compact('user','course_lesson','order_course','course','prev_lesson','next_lesson'));
        }
        return view('userboard.lesson_details',compact('user','course','order_course'));

    }
    public function watchLesson(Lesson $lesson){
        $user = auth()->user();
        $course_lesson = $lesson;
        $course = Course::with('chapters')->where('id',$lesson->course_id)->first();
        $order_course = OrderCourse::where('user_id',$user->id)->where('course_id',$course->id)->first();
        $chapters = $course->chapters->sortBy('order')->values();


        $currentChapterIndex = $chapters->search(function ($chapter) use ($lesson) {
            return $chapter->id == $lesson->chapter_id;
        });
    
        // Find the previous and next lessons within the same chapter
        $prev_lesson = Lesson::where('course_id', $lesson->course_id)
            ->where('chapter_id', $course_lesson->chapter_id)
            ->where('order', $lesson->order - 1)
            ->first();
    
        $next_lesson = Lesson::where('course_id', $lesson->course_id)
            ->where('chapter_id', $course_lesson->chapter_id)
            ->where('order', $lesson->order + 1)
            ->first();
    
        // If no previous lesson in the current chapter, find the last lesson of the previous chapter
        if (!$prev_lesson && $currentChapterIndex > 0) {
            $previousChapter = $chapters[$currentChapterIndex - 1];
            $prev_lesson = Lesson::where('course_id', $lesson->course_id)
                ->where('chapter_id', $previousChapter->id)
                ->orderBy('order', 'desc')
                ->first();
        }
        if (!$next_lesson && $currentChapterIndex < $chapters->count() - 1) {
            $previousChapter = $chapters[$currentChapterIndex + 1];
            $next_lesson = Lesson::where('course_id', $lesson->course_id)
                ->where('chapter_id', $previousChapter->id)
                ->orderBy('order', 'asc')
                ->first();
        }
        return view('userboard.lesson_details',compact('user','course_lesson','course','prev_lesson','next_lesson','order_course'));
    }

    public function getExame(Exame $exame){
        $user = auth()->user();
        $exame = Exame::with('questions')->where('id',$exame->id)->first();
        return view('userboard.exame',compact('exame','user'));
    }
    public function submitExame(Request $request,$exame_id){
        $user_id = auth()->user()->id;
        $exame = Exame::with('questions')->where('id',$exame_id)->first();
        $questions = $exame->questions;
        $count_questions = count($questions);
        $right_answers=0;
        if(!$request->answer){
            return redirect('user/my-quizes')->with('error', __('home.you didnt asnwer any questions'));
        }
        foreach($request->answer as $question_id=>$user_answer){
            $answer_check = $questions->where('id',$question_id)->first()->answers->where('id',$user_answer)->where('is_correct',1)->first();
            $right_answers = $answer_check?$right_answers+1 : $right_answers;
            ExameUserAnswer::updateOrCreate(
                ['user_id'=>$user_id,'exame_id'=>$exame_id,'question_id'=>$question_id],  // condition
                ['answer_id'=>$user_answer] // to update
            );

        }
        $result = ExameUserResult::updateOrCreate(
            ['user_id'=>$user_id,'course_id'=>$exame->course_id,'exame_id'=>$exame_id],
            ['result'=>$right_answers/$count_questions*100]
        );
            return redirect('user/my-quizes')->with('success', __('home.You have got :'). $result->result.'%');
    }

    public function updateProgress(Request $request){
        $lesson  = Lesson::findOrFail($request->course_lesson_id);
        $n_lessons = Lesson::where('course_id',$lesson->course_id)->count();
        $lessonHistory = LessonHistory::firstOrNew(['lesson_id' => $request->course_lesson_id,'course_id'=>$lesson->course_id,'user_id'=>auth()->user()->id]);
        $lessonHistory->save();
        $n_lessons_hostory = LessonHistory::where('course_id',$lesson->course_id)->where('user_id',auth()->user()->id)->count();
        $course_progress = $n_lessons_hostory/$n_lessons*100;
        OrderCourse::where('user_id',auth()->user()->id)->where('course_id',$lesson->course_id)->update(['progress'=>$course_progress]);
        return $course_progress;
    }
    
    public function getMyCertificate(Request $request){
        $user = auth()->user();
        $lang = LaravelLocalization::getCurrentLocale();
        $course = Course::findOrFail($request->course_id);
        $certificate_course = Certificate::where('course_id',$request->course_id)->where('user_id',auth()->user()->id)->first();
        if(!$certificate_course){
            $certificate_course = Certificate::create([
                'user_id'=>auth()->user()->id,
                'course_id'=>$request->course_id,
                'certificate_code'=> rand(100,1000000).'-'.$course->name_en.'-'.auth()->user()->id.'-'.rand(100,1000000),
                'status'=>1,
            ]);
        }
        $options = new \Dompdf\Options();
        $options->setIsRemoteEnabled(true);

        $dompdf =new \Dompdf\Dompdf($options);
        $dompdf->set_paper('A4', 'landscape');

        $view = view('userboard.certificate_form_pdf', compact('course', 'user','certificate_course'))->render();
        $dompdf->loadHtml($view);
        $dompdf->render();

        return $dompdf->stream('certificate.pdf', ['Attachment' => false]);
    }
    
    public function myWebinars(){
        $user = auth()->user();
        $my_webinars = $user->webinars;
        return view('userboard.myWebinars',compact('user','my_webinars'));
    }
    public function watchWebinar($link){
        $user = auth()->user();
        $webinar = Event::orwhere('link_en',$link)->orwhere('link_ar',$link)->first();
        return view('userboard.webinar_video',compact('user','webinar'));
    }
    
}