<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\TrainingField;
use App\Helpers\Helper;

class TrainingFieldController extends Controller
{

    public function __construct()
    {
        // $this->middleware('permission:field');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $fields = TrainingField::all();
        return view('admin.fields.fields',compact('fields'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.fields.addField');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            // 'name_en' => 'required|string',
            'name_ar' => 'required|string',
            // 'status' => 'required|string',
        ]);

        $add = new TrainingField();
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->status = $request->status;
        $add->menu = $request->menu;
        $add->created_by = auth()->user()->id;

        $link_en = str_replace(" ","-",$add->name_en);
        $add->link_en = str_replace(" ","-",$link_en);  
        $link_ar = str_replace(" ","-",$add->name_ar);
        $add->link_ar = str_replace(" ","-",$link_ar); 
        
        $add->meta_title_en = $request->meta_title_en;
        $add->meta_desc_en = $request->meta_desc_en;
        $add->meta_title_ar = $request->meta_title_ar;
        $add->meta_desc_ar = $request->meta_desc_ar;
        $add->meta_robots = $request->meta_robots ; 
        $add->alt_img = $request->alt_img ;
        
        if($request->image){
            $add->image = Helper::uploadImage('fields',$request->image);
        } 
        $add->save();
        
        return redirect('admin/fields')->with('success',trans('home.your_item_added_successfully'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $field = TrainingField::find($id);
        if($field){
            return view('admin.fields.editField',compact('field'));
        }else{
            abort('views.404');
        }
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            // 'name_en' => 'required|string',
            'name_ar' => 'required|string',
            // 'status' => 'required|string',
        ]);

        $add = TrainingField::findOrFail($id);
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
         $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->status = $request->status;
        $add->menu = $request->menu;
        $add->updated_by = auth()->user()->id;

        $link_en = str_replace(" ","-",$add->name_en);
        $add->link_en = str_replace(" ","-",$link_en);  
        $link_ar = str_replace(" ","-",$add->name_ar);
        $add->link_ar = str_replace(" ","-",$link_ar); 
        
        $add->meta_title_en = $request->meta_title_en;
        $add->meta_desc_en = $request->meta_desc_en;
        $add->meta_title_ar = $request->meta_title_ar;
        $add->meta_desc_ar = $request->meta_desc_ar;
        $add->meta_robots = $request->meta_robots ; 
        $add->alt_img = $request->alt_img ;
        
          if($add->image && $request->image){
            $add->image = Helper::updateUploadedImage('fields',$request->image ,$add->image);
        }elseif($request->image){
            $add->image = Helper::uploadImage('fields',$request->image);
        } 
        $add->save();
        
        return redirect('admin/fields')->with('success',trans('home.your_item_added_successfully'));
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids){
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        $img_path = base_path() . '/uploads/fields/';
        if($allElements){
            
            foreach ($ids as $id) {
                $field = TrainingField::findOrFail($id);
                if ($field->image) {
                    (file_exists(sprintf($img_path . '%s', $field->image)))?unlink(sprintf($img_path . '%s', $field->image)):'';
                }
            }
            Schema::disableForeignKeyConstraints();
            TrainingField::truncate();
            
        }else{
        
            foreach ($ids as $id) {
                $field = TrainingField::findOrFail($id);
                if ($field->image) {
                    (file_exists(sprintf($img_path . '%s', $field->image)))?unlink(sprintf($img_path . '%s', $field->image)):'';
                }
                $field->delete();
            }
        }
    }
}
