<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\TrainingCourse;
use App\Models\Training;
use App\Models\InstructorInfo;
use App\Models\TrainingAttendance;
use App\Models\TrainingSchadual;
use App\Models\TrainingSurvey;
use App\Models\Student;
use App\Models\User;
use App\Models\Partner;
use App\Models\TrainingAttendanceAttachments;
use DB;
use File;
use Image;
use App\Helpers\Helper;
use Maatwebsite\Excel\Facades\Excel;
use Barryvdh\DomPDF\Facade\Pdf;
use Dompdf\Dompdf;
use Dompdf\Options;

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;
use App\Exports\AttendanceExport;
// use ZipArchive;
// use Symfony\Component\HttpFoundation\StreamedResponse;
// use Illuminate\Support\Facades\Response;


class TrainingAttendanceController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('permission:attendance')->except('attend_me');
    }
    
    
    public function export_attendance(Request $request){
        $id = $request->id;
        $lang = \LaravelLocalization::getCurrentLocale();
        $training = Training::with('students','students.attendance')->find($id);
        return (new AttendanceExport($training, $lang))->download($training->code.'.xlsx');
    }
    
    public function attachmentChangeRate(Request $request){
        $attachment = TrainingAttendanceAttachments::findOrFail($request->attachment_id);
        $attachment->update(['rating' => $request->rate]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // return Training::find(1)->students->first()->attendance;
         if(auth()->user()->type=="partner"){
            // $center_ids = auth()->user()->partner->centers->pluck('id')->toArray();
            $center_ids =Partner::where('user_id',auth()->user()->id)->pluck('center_id')->toArray();
            $training_ids = TrainingSchadual::whereIn('center_id',$center_ids)->pluck('training_id')->toArray();
            $trainings = Training::whereIn('id',$training_ids)->orderBy('id','DESC')->where('status',1)->get();
        }
        elseif(auth()->user()->type=="instructor"){
            // $instructor_id = InstructorInfo::where('user_id',auth()->user()->id)->first()->id;
            $training_ids = TrainingCourse::where('instructor_id',auth()->user()->id)->pluck('training_id')->toArray();
            $trainings = Training::whereIn('id',$training_ids)->orderBy('id','DESC')->where('status',1)->get();
        }
        elseif(auth()->user()->type=="coordinator"){
            $trainings = Training::where('coordinator_id',auth()->user()->id)->orderBy('id','DESC')->where('status',1)->get();
        }
        elseif(auth()->user()->type=="marketer"){
            $trainings = Training::where('marketer_id',auth()->user()->id)->orderBy('id','DESC')->where('status',1)->get();
        }
        else{
            $trainings = Training::where('status',1)->orderBy('id','DESC')->get();
        }
        
        return view('admin.attendances.index',compact('trainings'));
    }
    
    public function attendanceSheet($training_id)
    {
        $training = Training::find($training_id);
        \Carbon\Carbon::setLocale('ar');
        $start_date = \Carbon\Carbon::parse($training->trainings_schaduals->start_date);
        $end_date = \Carbon\Carbon::parse($training->trainings_schaduals->end_date);
        $dates = [];
        $dates_d = [];
        while ($start_date <= $end_date) {
            $dates[] = [
                'date' => $start_date->toDateString(),
                'day_name' => $start_date->isoFormat('dddd')
            ];
            $dates_d[] = $start_date->toDateString();
            $start_date->addDay();
        }
        $attendance_dates = TrainingAttendance::select('attendance_date')->where('training_id', $training_id)->groupBy('attendance_date')->orderBy('attendance_date', 'ASC')->pluck('attendance_date')->toArray();
        $attendance_dates_d = [];
        foreach ($attendance_dates as $a_d) {
            if (in_array(\Carbon\Carbon::parse($a_d)->toDateString(), $dates_d)) {
                $attendance_dates_d[] = \Carbon\Carbon::parse($a_d)->toDateString();
            }
        }
    
        $attendances = Student::with('attendance', 'studentinfo', 'user')->where('training_id', $training_id)->get();
    
        // Convert view to HTML
        $view = view('admin.attendances.attendance_sheet', compact('attendances', 'dates', 'attendance_dates_d', 'start_date', 'end_date'))->render();
    
        // Convert Arabic characters in the HTML content
         $view = $this->convertArabicCharacters($view);
    
        // Dompdf options and initialization
        $options = new \Dompdf\Options();
        $options->set('fontDir', public_path('fonts'));
        $options->set('defaultFont', 'Cairo');
        $options->set('isHtml5ParserEnabled', true);
        $options->set('isRemoteEnabled', true);
    
        $dompdf = new \Dompdf\Dompdf($options);
        $dompdf->setPaper('A4', 'landscape');
    
        // Load HTML and render
        $dompdf->loadHtml($view);
        $dompdf->render();
    
        // Return the generated PDF as a downloadable response
        return $dompdf->stream($training->code . '-attendance_sheet.pdf', ['Attachment' => false]);
    }
    
    private function convertArabicCharacters($htmlContent)
    {
        $Arabic = new \ArPHP\I18N\Arabic();
        $p = $Arabic->arIdentify($htmlContent);
        for ($i = count($p) - 1; $i >= 0; $i -= 2) {
            $utf8ar = $Arabic->utf8Glyphs(substr($htmlContent, $p[$i - 1], $p[$i] - $p[$i - 1]));
            $htmlContent = substr_replace($htmlContent, $utf8ar, $p[$i - 1], $p[$i] - $p[$i - 1]);
        }
        return $htmlContent;
    }
    
    public function attendance_details(Request $request){
        $training_id =$request->training_id; 
        $user = User::find($request->user_id);
        $attendances = TrainingAttendance::with('user','training')->where('user_id',$user->id)->where('training_id',$training_id)->get();
        return response()->json(['view' => view('admin.attendances.edit', compact('attendances','training_id','user'))->render()]);
        
    }
    // show attendance of students for training
    public function show($id){
        $training = Training::with('students','students.attendance')->find($id);
        $start_day = \Carbon\Carbon::parse($training->trainings_schaduals->start_date)->format("d");
        $end_day = \Carbon\Carbon::parse($training->trainings_schaduals->end_date)->format("d");
        $enabledDays = range($start_day, $end_day);
        return view('admin.attendances.training_attendance',compact('training','enabledDays'));
    }
    
    
    
    // admin attend students
    public function attend_students(Request $request){
        $attendance_date = $request->attend_date;
        $training_id =$request->training_id;
        $training = Training::find($training_id);
        
        if ($request->attendance_sheet) {
            $attendance_sheet_name = Helper::uploadAttendanceFile('trainings/attendance_attachments', $request->attendance_sheet,$training->code);
        }
        if ($request->ownership_rights) {
            $ownership_rights_name = Helper::uploadAttendanceFile('trainings/attendance_attachments', $request->ownership_rights,$training->code);
        }
        if ($request->attachments) {
            $attachments_name = Helper::uploadAttendanceFile('trainings/attendance_attachments', $request->attachments,$training->code);
        }
        
        
        $ids = $request->id;
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        foreach ($ids as $id) {
            $training_check = TrainingAttendance::where('training_id', $training_id)->where('user_id',$id)->where('attendance_date',$attendance_date)->first();
            if(!$training_check){
                $training_attendance = TrainingAttendance::create(['user_id'=>$id,'training_id'=> $training_id,'attendance_date'=>$attendance_date, 'created_by' => auth()->user()->id]);
                $check_training_attachments=TrainingAttendanceAttachments::where('attendance_date',$attendance_date)->where('training_id',$training_id)->first();
                if ($request->attendance_sheet) {
                    if (!$check_training_attachments) {
                        TrainingAttendanceAttachments::create([
                            'training_id'=>$training_id,
                            'training_attendance_id'=>$training_attendance->id,
                            'attachments'=>$attendance_sheet_name,
                            'type'=>'sheet',
                            'attendance_date'=>$attendance_date,
                        ]);
                    }
                }
                if ($request->ownership_rights) {
                    if (!$check_training_attachments) {
                        TrainingAttendanceAttachments::create([
                            'training_id'=>$training_id,
                            'training_attendance_id'=>$training_attendance->id,
                            'attachments'=>$ownership_rights_name,
                            'type'=>'ownership_rights',
                            'attendance_date'=>$attendance_date,
                        ]);
                    }
                }
                if ($request->attachments) {
                    if (!$check_training_attachments) {
                        TrainingAttendanceAttachments::create([
                            'training_id'=>$training_id,
                            'training_attendance_id'=>$training_attendance->id,
                            'attachments'=>$attachments_name,
                            'type'=>'attachments',
                            'attendance_date'=>$attendance_date,
                        ]);
                    }
                }
                
                
                
            }
        }
        toastr()->success(trans('home.your_item_added_successfully'), trans('home.saved'));
        // return 'done';
    }
    
 

 
    public function delete_attendance_attachment($id)
    {
        TrainingAttendanceAttachments::destroy($id);
    }
    public function delete_attend(Request $request)
    {
        $attendance_date = $request->attend_date;
        $training_id =$request->training_id; 
        $ids = $request->id;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        TrainingAttendance::whereIn('user_id',$ids)->where('training_id',$training_id)->where('attendance_date',$attendance_date)->delete();

        return 'done';
    }
    
    public function attendance_attachments(Request $request){
        $training_id =$request->training_id; 
        $training = Training::where('id',$training_id)->first();
        $attendances = TrainingAttendanceAttachments::where('training_id',$training_id)->get();
        return response()->json(['view' => view('admin.attendances.ShowAttendanceAttachments', compact('attendances','training'))->render()]);
    }

    
    
}
