<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Teacher;
use File;
use Image;
class TeacherController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('permission:teachers');
    }

    public function index()
    {
        $teachers =Teacher::get();
        return view('admin.teachers.teachers',compact('teachers'));
    }
        public function create()
    {
        return view('admin.teachers.addTeacher');
    }
    public function store(Request $request){
        $request->validate([
          'image' => 'image|mimes:jpeg,png,jpg,gif,svg,webp'
        ]);
        $teacher = new Teacher();
        $teacher->name = $request->name;
        $teacher->email = $request->email;
        $teacher->phone = $request->phone;
        $teacher->category_en = $request->category_en;
        $teacher->category_ar = $request->category_ar;
        $teacher->text_en = $request->text_en;
        $teacher->text_ar = $request->text_ar;

        $teacher->facebook = $request->facebook;
        $teacher->pintrest = $request->pintrest;
        $teacher->youtube = $request->youtube;
        $teacher->linkedin = $request->linkedin;
        $teacher->instgram = $request->instgram;
        $teacher->position_en = $request->position_en;
        $teacher->position_ar = $request->position_ar;

        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/users/source/' . $fileName);

            Image::make($file->getRealPath())->save($path);

            $teacher->image = $fileName;
        }
        $teacher->save();
        return redirect('admin/teachers')->with('success',trans('home.your_item_added_successfully'));

    }
    public function edit($id){
        $teacher = Teacher::find($id);
        if($teacher){
            return view('admin.teachers.editTeacher',compact('teacher'));
        }
        else{
            abort('404');
        }
    }
    public function update(Request $request, $id){
        $request->validate([
          'image' => 'image|mimes:jpeg,png,jpg,gif,svg,webp'
        ]);
        $teacher = Teacher::find($id);
        $teacher->name = $request->name;
        $teacher->email = $request->email;
        $teacher->phone = $request->phone;
        $teacher->category_en = $request->category_en;
        $teacher->category_ar = $request->category_ar;
        $teacher->text_en = $request->text_en;
        $teacher->text_ar = $request->text_ar;
        $teacher->position_en = $request->position_en;
        $teacher->position_ar = $request->position_ar;


        $teacher->facebook = $request->facebook;
        $teacher->pintrest = $request->pintrest;
        $teacher->youtube = $request->youtube;
        $teacher->linkedin = $request->linkedin;
        $teacher->instgram = $request->instgram;

        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $img_path = base_path() . '/uploads/users/source/';
            if ($teacher->image != null) {
                file_exists($img_path.$teacher->image) ? unlink($img_path . $teacher->image):'';
            }
           // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/users/source/' . $fileName);
              //  $file->move($destinationPath, $fileName);

            Image::make($file->getRealPath())->save($path);

            $teacher->image = $fileName;
        }
        $teacher->save();
        return redirect('admin/teachers')->with('success',trans('home.your_item_updated_successfully'));
    }
    public function show(){
        //
    }

    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        $img_path = base_path() . '/uploads/users/source/';

        foreach ($ids as $id) {
            $m = Teacher::findOrFail($id);
            if ($m->image != null) {
                file_exists($img_path.$m->image) ? unlink($img_path . $m->image):'';
            }
            $m->delete();
        }
    }

    


}
