<?php

namespace App\Http\Controllers;

use App\Models\TrainingCourse;
use App\Models\TrainingSurvey;
use App\Models\InstructorInfo;
use App\Models\Survey;
use App\Imports\SurveyResultImport;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\SurveyQuestion;
use App\Models\SurvayResult;
use App\DataTables\TrainingSurveyResultDataTable;
use App\Helpers\Helper;
use Illuminate\Http\Request;

class SurveyResultController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct(){
        //$this->middleware(['permission:surveys']);
    }

    public function index(TrainingSurveyResultDataTable $dataTable)
    {
        return $dataTable->render('admin.surveys.trainings_surveys_results');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // return view('admin.surveys.addSurvey');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        // $add = new Survey();
        // $add->name_en = $request->name_en;
        // $add->name_ar = $request->name_ar;
        // $add->survay_type = $request->survay_type;
        // $add->status = $request->status;
        // $add->created_by = auth()->user()->id;
       
        // $add->save();

        // ////// save questions //////
        // $questions_name_en = $request->question_en;
        // if($request->question_en){
        //     $questionTypes =$request->question_type; 
        //     $questions_name_ar = $request->question_ar;
        //     foreach($questions_name_en as $key=>$question_name_en){
        //         if($question_name_en && $questions_name_ar[$key] && $questionTypes[$key]){
        //             $surveyquestion = new SurveyQuestion();
        //             $surveyquestion->survay_id = $add->id;
        //             $surveyquestion->question_en = $question_name_en;
        //             $surveyquestion->question_ar = $questions_name_ar[$key];
        //             $surveyquestion->question_type = $questionTypes[$key];
        //             $surveyquestion->created_by = auth()->user()->id;

        //             $surveyquestion->save();
        //         }
        //     }
        // }

        // toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));

        // return redirect('admin/surveys');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id,$training_id)
    {
        $survey = Survey::findOrFail($id);
        $user_ids = SurvayResult::where('survay_id',$id)->where('training_id',$training_id)->groupBy('user_id')->pluck('user_id')->toArray();
        $company_q_ids = SurvayResult::where('survay_id',$id)->where('training_id',$training_id)->groupBy('created_at')->pluck('id')->toArray();
        $survey_results = SurvayResult::where('survay_id',$id)->where('training_id',$training_id)->get();
        $perfect_count = SurvayResult::where('survay_id',$id)->where('answer','Perfect')->where('training_id',$training_id)->count();
        $good_count = SurvayResult::where('survay_id',$id)->where('answer','Good')->where('training_id',$training_id)->count();
        $average_count = SurvayResult::where('survay_id',$id)->where('answer','Average')->where('training_id',$training_id)->count();
        $poor_count = SurvayResult::where('survay_id',$id)->where('answer','Poor')->where('training_id',$training_id)->count();
        $very_bad_count = SurvayResult::where('survay_id',$id)->where('answer','Very Bad')->where('training_id',$training_id)->count();
        
        // return $perfect_num;
        return view('admin.surveys.survey_question_answers',compact('training_id','survey','survey_results','user_ids','company_q_ids','perfect_count','good_count','average_count','poor_count','very_bad_count'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $training_surveys=TrainingSurvey::where('training_id',$id)->get();

        return view('admin.surveys.training_surveys',compact('training_surveys','id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids)
    {
        //
    }
    
    public function importExcel(Request $request)
    {
        if (empty($request->file('excelFile'))) {
            toastr()->error(trans('home.file_not_found'), trans('home.not_found'));
            return redirect()->back();
        }
        $results = Excel::import(new SurveyResultImport,$request->file('excelFile'));

        foreach ($results as $result) {
            SurvayResult::create($result);
        }

        toastr()->success(trans('home.file_uploaded_successfully'), trans('home.file_uploaded'));
        return redirect()->back();
    }
    

}
