<?php

namespace App\Http\Controllers;

use App\Models\TrainingCourse;
use App\Models\TrainingSurvey;
use App\Models\InstructorInfo;
use App\Models\Survey;
use App\Models\SurveyQuestion;
use App\Helpers\Helper;
use Illuminate\Http\Request;
class SurveyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct(){
        //$this->middleware(['permission:surveys']);
    }

    public function index()
    {
        if(auth()->user()->type=="instructor"){
            // $instructor_id = InstructorInfo::where('user_id',auth()->user()->id)->first()->id;
            $training_ids = TrainingCourse::where('instructor_id',auth()->user()->id)->pluck('training_id')->toArray();
            $survey_ids = TrainingSurvey::whereIn('training_id',$training_ids)->pluck('survey_id')->toArray();
            $surveys = Survey::whereIn('id',$survey_ids)->orderBy('id','DESC')->get();
        }else {
            $surveys = Survey::orderBy('id','DESC')->get();
        }
        return view('admin.surveys.surveys',compact('surveys'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.surveys.addSurvey');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        $add = new Survey();
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->survay_type = $request->survay_type;
        $add->status = $request->status;
        $add->created_by = auth()->user()->id;
       
        $add->save();

        ////// save questions //////
        $questions_name_en = $request->question_en;
        if($request->question_en){
            $questionTypes =$request->question_type; 
            $questions_name_ar = $request->question_ar;
            foreach($questions_name_en as $key=>$question_name_en){
                if($question_name_en && $questions_name_ar[$key] && $questionTypes[$key]){
                    $surveyquestion = new SurveyQuestion();
                    $surveyquestion->survay_id = $add->id;
                    $surveyquestion->question_en = $question_name_en;
                    $surveyquestion->question_ar = $questions_name_ar[$key];
                    $surveyquestion->question_type = $questionTypes[$key];
                    $surveyquestion->created_by = auth()->user()->id;

                    $surveyquestion->save();
                }
            }
        }

        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));

        return redirect('admin/surveys');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $survey=Survey::findOrFail($id);
        $surveyQuestions = SurveyQuestion::where('survay_id',$id)->get();

        return view('admin.surveys.editSurvey',compact('survey','surveyQuestions'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // return $request;
        $add = Survey::find($id);
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->survay_type = $request->survay_type;
        $add->status = $request->status;
        $add->updated_by = auth()->user()->id;
        
        $add->save();

        ////// save questions //////
        $questions_name_en = $request->question_en;
        if($request->question_en){
            $questionTypes =$request->question_type; 
            $questions_name_ar = $request->question_ar;
            foreach($questions_name_en as $key=>$question_name_en){
                if($question_name_en && $questions_name_ar[$key] && $questionTypes[$key]){
                    $surveyquestion = new SurveyQuestion();
                    $surveyquestion->survay_id = $add->id;
                    $surveyquestion->question_en = $question_name_en;
                    $surveyquestion->question_ar = $questions_name_ar[$key];
                    $surveyquestion->question_type = $questionTypes[$key];
                    $surveyquestion->updated_by = auth()->user()->id;
                    
                    $surveyquestion->save();
                }
            }
        }

        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));

        return redirect('admin/surveys');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            $survey = Survey::findOrFail($id);
           $survey->delete();
        }
    }
    
    
    public function updateSurveyQuestion(Request $request){
        // return $request;
        $surveyQuestion=SurveyQuestion::findOrFail($request->question_id);
        $surveyQuestion->update([
            'question_en' => $request->question_en,    
            'question_ar' => $request->question_ar,
            'question_type' => $request->question_type,  
            'updated_by' => auth()->user()->id,
        ]);
        
        toastr()->success(trans('home.survey_question_updated_successfully') , trans('home.updated'));
        return back();
    }

    public function removeSurveyQuestion(){
        $question_id = $_POST['question_id'];
        SurveyQuestion::destroy($question_id);
        toastr()->error(trans('home.survey_question_deleted_successfully') , trans('home.deleted'));
        return back();
    }

}
