<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Lang;
use App\Models\Page;
use App\Models\Menu;
use App\Models\MenuItem;
use App\Models\Center;
use App\Models\ExameResult;
use App\Models\Survey;
use App\Models\TrainingAttendance;
use App\Models\User;
use App\Models\ExameAnswer;
use App\Models\StudentRequest;
use App\Models\Student;
use App\Rules\MatchOldPassword;
use Illuminate\Support\Facades\Hash;
use Auth;
use App\Models\Exame;
use App\Models\TrainingExam;
use App\Models\Course;
use App\Models\SurvayResult;
use App\Models\Lesson;
use App\Models\Training;
use App\Models\ExameQuestion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Helpers\Helper;
use Dompdf\Dompdf;
use Dompdf\Options;
use ZipArchive;
use Illuminate\Support\Facades\Response;


class StudentBoardController extends Controller
{
    public function index(){
        $training_ids =  auth()->user()->trainings->pluck('training_id')->toArray();
        $trainings = Training::with(['am_student','trainingSurvey.survey.survayResult','trainingSurvey.survey.surveyQuestions','courses','courses.student_lessons','courses.student_lessons.attachments'
        ,'courses.student_lessons.questions', 'courses.course_info','trainings_schaduals.center','exame','exame.questions','exame.questions.answers','training_attendance'])->whereIn('id',$training_ids)->get() ;
        $instructorsInfo = [];
        
        
        // return Training::find(295)->courses->first()->course_info->student_training_bag;
        
        foreach ($trainings as $training) {
            $instructorInfo = $training->instructor_info();
            if ($instructorInfo) {
                $instructorInfo->training_id = $training->id;
                $instructorsInfo[$training->id] = $instructorInfo;
            }
        }
        return view('studentBoard.index',compact('trainings','instructorsInfo'));
    }
    
    public function lesson_videos($course_code,$lesson_id){
        $course = Course::where('code',$course_code)->first();
        $lesson = Lesson:: find($lesson_id);
        return view('studentBoard.course_videos',compact('course','lesson'));
    }
    public function watch_training($training_id){
        $training_ids =  auth()->user()->trainings->pluck('training_id')->toArray();
        if(in_array($training_id,$training_ids)){
            $training = Training::with(['courses', 'courses.course_info','trainings_schaduals.center','exame'])->find($training_id);
            $attendances = TrainingAttendance::where('user_id',auth()->user()->id)->where('training_id',$training_id)->get();
            $exame = Exame::find($training->exame->exam_id);
            $exame_questions = ExameQuestion::with('answers')->where('exame_id',$training->exame->exam_id)->get();
            return view('studentBoard.training_details',compact('training','attendances','exame_questions','exame'));
        }else{
            abort('404');
        }
    }
    public function watch_course($course_id){
        $training_ids =  auth()->user()->trainings->pluck('training_id')->toArray();
        // Check if any of the trainings have the given course ID
        $training= Training::whereHas('courses', function ($query) use ($course_id) {
            $query->where('course_id', $course_id);
        })->whereIn('id', $training_ids)->first();
        // If the course is associated with any of the trainings, retrieve the course details
        if ($training) {
            $course = Course::with(['student_lessons' => function ($query) {
                $query->with('attachments','questions');
            }])->find($course_id);
            return $course;
            
            return view('studentBoard.course_details', compact('course','training'));

        }else{
            abort('404');
        }
    }
    
    public function register_training(Request $request){
        $user = User::with('student_info')->find(auth()->user()->id);
        if($user->student_info->ssn){
            
            $studentRequest = StudentRequest::firstOrCreate([
                'user_id' => auth()->user()->id,
                'course_id' => $request->course_id,
                'seen' => '0'
            ]);
                
            toastr()->success(trans('home.your_request_send_successfully'));
            return redirect('/student');
        }else{
          toastr()->error(trans('home.your_profile_doesnt_have_ssn'));
            return redirect('/student');
        }
        
    }
       // student atttend him self
    public function attend_me($id)
    {
        $user_id = auth()->user()->id;
        $attendance_date = \Carbon\Carbon::today()->toDateString();
        $training_check = TrainingAttendance::where('training_id', $id)->where('user_id',$user_id)->where('attendance_date',$attendance_date)->first();
        if(empty($training_check)){
            TrainingAttendance::create(['user_id'=>$user_id,'training_id'=> $id,'attendance_date'=>$attendance_date]);
            toastr()->success(trans('home.Your attended today successfully'));
            return redirect('/student');
        }
        toastr()->error(trans('home.You have attended already for today'));
        return redirect('/student');
    }
    
    public function submit_exame(Request $request){
        $training_exame = TrainingExam::where('training_id',$request->training_id)->first(); //for success rate %
        $check_submitted = ExameResult::where('user_id',auth()->user()->id)->where('exame_id',$request->exame_id)->get();  // if he as already submit
        $check_submitted_result = $check_submitted->pluck('result'); // check biggest result
        $max_result = $check_submitted_result->max();
        if(count($check_submitted) >= $training_exame->n_try){
            
            // has already submit AND passed this exame
            if( $max_result >= $training_exame->success_rate ){
                toastr()->success(trans('home.you have already submited this exame and passed'),$max_result.'  %' );
                Session::put('success',trans('home.you have already submited this exame and passed').' .... '.$max_result.'  %');
                return back();
            }else{
                toastr()->error(trans('home.you have already submited this exame').' '.count($check_submitted).__('home.and didnt pass'),$max_result.'  %' );
                return back();
            }
        }
        
        // ---------------- submit new answers ---------------
        
        $questions = $request->questions;
        $answers = $request->answers;
        $index_right_answers_results = 0;
        $right_answers_ids = ExameAnswer::whereIn('question_id',$questions)->where('is_correct',1)->pluck('id')->toArray();
        foreach ($answers as $answer_id) {
            if(in_array($answer_id,$right_answers_ids)){
                $index_right_answers_results ++;
            }
        }
        $result = $index_right_answers_results/count($questions)*100;
        ExameResult::create(['user_id'=>auth()->user()->id,'exame_id'=>$request->exame_id,'result'=>$result]);
        
        //  if not success
        if( $result <= $training_exame->success_rate ){
            if($training_exame->n_try !=1){
                toastr()->error(trans('home.you didnt pass this exame').' '.$result.'  %'.__('home.and your chances is').' '.$training_exame->n_try-count($check_submitted)-1 );
            }else{
                toastr()->error(trans('home.you didnt pass this exame'),$result.'  %' );
            }
            return back();
        }
        
        $student = Student::where('training_id',$request->training_id)->where('user_id',$request->user_id)->first();
        $student->view_certifiacte=1;
        $student->save();
        toastr()->success(trans('home.congratulations'),$result.'  %' );
        Session::put('accepted_request',trans('home.congratulations').' .... '.$result.'  %');
        return back();
    }
    
    public function submit_survay(Request $request){
        // return $request;
        $survey_id = $request->survey_id;
        $training_id = $request->training_id;
        $questions = $request->questions;
        $answers = $request->answers;
        
        $attached_questions = $request->attached_questions;
        $attached_files = $request->file('attached');
 
        foreach($answers as $question_id => $answer) {
            $surveyResult = new SurvayResult();
            $surveyResult->user_id = auth()->user()->id;
            $surveyResult->survay_id = $survey_id;
            $surveyResult->training_id = $training_id;
            $surveyResult->survay_question_id = $question_id; // Assuming the key of $answers array is the question ID
            $surveyResult->answer = $answer;
            $surveyResult->save();
        }
        
        if ($attached_files) {
            foreach ($attached_files as $question_id =>$attached_file) {
                $surveyResult = new SurvayResult();
                $surveyResult->user_id = auth()->user()->id;
                $surveyResult->survay_id = $survey_id;
                $surveyResult->training_id = $training_id;
                $surveyResult->survay_question_id = $question_id;
                $surveyResult->answer = Helper::uploadFile('survays_answers',$attached_file);
                $surveyResult->save();
            }
        }
        
        
        toastr()->success(trans('home.thank_you'));
        return back();
        
    }
    
    public function updateAccountSetting(Request $request){
        $user = Auth::user();

        $user->f_name=$request->f_name?$request->f_name:$user->f_name;
        $user->l_name=$request->l_name?$request->l_name:$user->l_name;
        if($request->email){
            $user->email=$request->email;
        }
        if ($request->hasFile("image")) {
            if($user->image=="profile.webp"){
                $user->image = Helper::uploadImage('users', $request->image);
            }else{
             $user->image = Helper::updateUploadedImage('users', $request->image,$user->image);
            }
        }
        $user->save();

        ////// change password////
        if($request->cur_password || $request->new_password || $request->conf_password){
            $request->validate([
                'cur_password' => ['required', new MatchOldPassword],
                'new_password' => ['required'],
                'conf_password' => ['same:new_password'],
            ]);

            $user->password = Hash::make($request->new_password);
            $user->save();
        }
        return redirect('student')->with('success',trans('home.your_data_have_been_updated_successfully'));
    }
    
    public function generate_certificates(Request $request) {
        $lang = \LaravelLocalization::getCurrentLocale();
        $ids = $request->ids;
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
    
        $training = Training::with('trainings_schaduals')->findOrFail($request->training_id);
        $students = Student::with('studentinfo','user')
            ->whereIn('user_id', $ids)
            ->where('training_id', $request->training_id)
            ->get();
    
        $zip = new ZipArchive();
        $zipFileName = $training->code . ' - ' . $training->{'name_'.$lang} . '.zip';
        $zipFilePath = public_path('generated_certificates_pdf/' . $zipFileName);

        // Ensure the directory exists
        if (!file_exists(public_path('generated_certificates_pdf'))) {
            mkdir(public_path('generated_certificates_pdf'), 0755, true);
        }
    
        if ($zip->open($zipFilePath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === true) {
            foreach ($students as $student) {
                $options = new \Dompdf\Options();
                $options->set('fontDir', public_path('fonts'));
                $options->set('defaultFont', 'Cairo');
        
                $dompdf = new \Dompdf\Dompdf($options);
                $dompdf->set_paper('A4', 'landscape');
                $dompdf->set_option('isRemoteEnabled', true);
        
                $view = view('admin.certificate_form_pdf', compact('student', 'training'))->render();
                $dompdf->loadHtml($view);
                $dompdf->render();
        
                $pdfFileName = tempnam(sys_get_temp_dir(), 'pdf');
                file_put_contents($pdfFileName, $dompdf->output());
        
                $zip->addFile($pdfFileName, $student->user->f_name . '.pdf');
            }
            $zip->close();
    
            // Clean up temporary files
            foreach ($students as $student) {
                $pdfFileName = sys_get_temp_dir() . '/' . $student->user->f_name . '.pdf';
                @unlink($pdfFileName);
            }
    
            if (file_exists($zipFilePath)) {
                return response()->download($zipFilePath)->deleteFileAfterSend(true);
            } else {
                return response()->json(['error' => 'Zip file does not exist after creation'], 500);
            }
        } else {
            return response()->json(['error' => 'Failed to create zip file'], 500);
        }
    }
    
}
