<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Service;
use App\Models\ServiceCategory;
use App\Models\Training;
use App\Models\TrainingField;
use App\Models\BlogItem;

class SiteMapController extends Controller
{
    public function index(){
	  return response()->view('sitemap.index')->header('Content-Type', 'text/xml');
	}

    public function services(){
        $services= Service::orderBy('order')->orderBy('name_ar')->latest()->get();
        return response()->view('sitemap.services-sitemap', [
    	      'services'=>$services,
    	])->header('Content-Type', 'text/xml');
    }
    
    public function courses(){
        $courses= Training::latest()->get();
        return response()->view('sitemap.courses-sitemap', [
    	      'courses' => $courses,
    	])->header('Content-Type', 'text/xml');
    }
    
    public function categories(){
        $categories= Category::latest()->get();
        return response()->view('sitemap.categories-sitemap', [
    	      'categories' => $categories,
    	])->header('Content-Type', 'text/xml');
    }
    
    public function serviceCategories(){
        $serviceCategories= ServiceCategory::latest()->get();
        return response()->view('sitemap.serviceCategories-sitemap', [
    	      'serviceCategories' => $serviceCategories,
    	])->header('Content-Type', 'text/xml');
    }
    
    public function fields(){
        $training_fields = TrainingField::latest()->get();
        return response()->view('sitemap.fields-sitemap', [
    	      'training_fields' => $training_fields,
    	])->header('Content-Type', 'text/xml');
    }
    
    public function blogs(){
        $blogs = BlogItem::latest()->get();
        return response()->view('sitemap.blogs-sitemap', [
    	      'blogs' => $blogs,
    	])->header('Content-Type', 'text/xml');
    }

}