<?php

namespace App\Http\Controllers;

use App\Models\Service;
use App\Models\ServiceCategory;
use File;
use Image;
use Auth;
use App\Models\ServiceImage;
use DB;
use Illuminate\Http\Request;
use App\Models\Faq;
use App\Helpers\Helper;
use Illuminate\Support\Facades\Schema;

class ServiceController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:service');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $services = Service::all();
        return view('admin.services.services',compact('services'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $serviceCategories = ServiceCategory::where('status',1)->get();
        $services = Service::get();
        return view('admin.services.addService',compact('services','serviceCategories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        $add = new Service();
        $add->servicecategory_id = $request->servicecategory_id;
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->order = $request->order;
        $add->link_en = str_replace(" ","-",$request->link_en);
        $add->link_ar = str_replace(" ","-",$request->link_ar);
        $add->short_text_en = $request->short_text_en;
        $add->short_text_ar = $request->short_text_ar;
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->alt_img = $request->alt_img;
        $add->alt_icon = $request->alt_icon;
        $add->redirect_url = $request->redirect_url;
        $add->youtube_link = $request->youtube_link ? $this->getYoutubeEmbedUrl($request->youtube_link) : '';
        $add->meta_title_en = $request->meta_title_en;
        $add->meta_title_ar = $request->meta_title_ar;
        $add->meta_desc_en =$request->meta_desc_en;
        $add->meta_desc_ar =$request->meta_desc_ar;
        $add->meta_robots =$request->meta_robots;
        $add->status = $request->status;
        $add->home = $request->home;
        $add->menu = $request->menu;
        $add->parent_id = $request->parent_id;
        
        if($request->img){
            $add->img = Helper::uploadImage('services',$request->img);
        } 
        
        if($request->icon){
            $add->icon = Helper::uploadImage('services',$request->icon);
        } 
        $add->save();
        
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('services.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $service=Service::find($id);
        if($service){
            $serviceCategories = ServiceCategory::where('status',1)->get();
            $questions = Faq::where('type','service')->where('service_id',$id)->get();
            $services = Service::get();

            $images = DB::table('temp_upload_files')->where('type','service')->where('service_id',$id)->get();
            if(count($images) > 0){
                foreach($images as $image){
                    try{
                        $img_path = base_path() . '/uploads/services/';
                        if($image->server_name){
                            (file_exists(sprintf($img_path . '%s', $image->server_name)))?unlink(sprintf($img_path . '%s', $image->server_name)):'';
                        }
                    }catch(Exception $e){
                    }
                }
                DB::table('temp_upload_files')->where('type','service')->where('service_id',$id)->delete();
                session()->forget('imagesUpload');
                session()->forget('imagesUploadRealName');
            }
            
            return view('admin.services.editService',compact('services','service','questions','serviceCategories'));
        }else{
            abort('404');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $add = Service::find($id);
        $add->servicecategory_id = $request->servicecategory_id;
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->order = $request->order;
        $add->link_en = str_replace(" ","-",$request->link_en);
        $add->link_ar = str_replace(" ","-",$request->link_ar);
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->short_text_en = $request->short_text_en;
        $add->short_text_ar = $request->short_text_ar;
        $add->alt_img = $request->alt_img;
        $add->alt_icon = $request->alt_icon;
        $add->redirect_url = $request->redirect_url;
        $add->youtube_link = $request->youtube_link ? $this->getYoutubeEmbedUrl($request->youtube_link) : '';
        $add->meta_title_en = $request->meta_title_en;
        $add->meta_title_ar = $request->meta_title_ar;
        $add->meta_desc_en =$request->meta_desc_en;
        $add->meta_desc_ar =$request->meta_desc_ar;
        $add->meta_robots =$request->meta_robots;
        $add->status = $request->status;
        $add->home = $request->home;
        $add->menu = $request->menu;
        $add->parent_id = $request->parent_id;

        if($add->img && $request->img){
            $add->img = Helper::updateUploadedImage('services',$request->img ,$add->img);
        }elseif($request->img){
            $add->img = Helper::uploadImage('services',$request->img);
        } 
        
        if($add->icon && $request->icon){
            $add->icon = Helper::updateUploadedImage('services',$request->icon ,$add->icon);
        }elseif($request->icon){
            $add->icon = Helper::uploadImage('services',$request->icon);
        } 
        $add->save();
        
        ///////// save project images//////
        if(\Session::has('imagesUpload')){
            $images = \Session::get('imagesUpload');
            foreach ($images as $key=>$file) {
                $img = new ServiceImage();
                $img->image = $file;
                $img->service_id=$add->id;
                $img->save();
            }
        }

        DB::table('temp_upload_files')->where('service_id',$id)->delete();
        session()->forget('imagesUpload');
        session()->forget('imagesUploadRealName');

        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return redirect()->route('services.index');
    }

    /////// upload service images///////////////
    public function uploadImages(Request $request){
        if($request->hasFile('file')){
            $file = $request->file("file");
            $fileName = Helper::uploadImage('services',$file);
            $realName = $file->getClientOriginalName();

            DB::table('temp_upload_files')->insert(['server_name' => $fileName,'original_name' => $realName ,'service_id' => $request->serviceId, 'type'=>'service']);
            if(\Session::has('imagesUpload')){
                \Session::push('imagesUpload',$fileName);
                \Session::push('imagesUploadRealName',$realName);
            }else{
                $images = [];
                array_push($images,$fileName);
                \Session::put('imagesUpload',$images);
                
                $realImages = [];
                array_push($realImages,$realName);
                \Session::put('imagesUploadRealName',$realImages);
            }
        } 
    }
    
    ///////// delete uploaded images///////////
    public function removeUploadImages(Request $request){
        $name = $request->name;
        $names = \Session::get('imagesUploadRealName');
        $images = \Session::get('imagesUpload');
        $key = array_search($name, $names);
        
        $img_path = base_path() . '/uploads/services/';
        (file_exists(sprintf($img_path . '%s', $images[$key])))?unlink(sprintf($img_path . '%s', $images[$key])):'';

        unset($images[$key]);
        unset($names[$key]);
        \Session::put('imagesUpload',$images);
        \Session::put('imagesUploadRealName',$names);
        DB::table('temp_upload_files')->where('original_name',$name)->delete();
    }
    
    public function deleteImege(){
        $serviceId = $_POST['serviceId'];
        $image = $_POST['image'];
        $img =ServiceImage::where('service_id',$serviceId)->where('id',$image)->first();

        $img_path = base_path() . '/uploads/services/';

        if ($img->image) {
            (file_exists(sprintf($img_path . '%s', $img->image)))?unlink(sprintf($img_path . '%s', $img->image)):'';
        }
        $img->delete();
    }
    
    function getYoutubeEmbedUrl($url){
         $shortUrlRegex = '/youtu.be\/([a-zA-Z0-9_-]+)\??/i';
         $longUrlRegex = '/youtube.com\/((?:embed)|(?:watch))((?:\?v\=)|(?:\/))([a-zA-Z0-9_-]+)/i';
    
        if (preg_match($longUrlRegex, $url, $matches)) {
            $youtube_id = $matches[count($matches) - 1];
        }
    
        if (preg_match($shortUrlRegex, $url, $matches)) {
            $youtube_id = $matches[count($matches) - 1];
        }
        return 'https://www.youtube.com/embed/' . $youtube_id ;
    }
    
    
    public function destroy($ids){
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        $img_path = base_path() . '/uploads/services/';
        if($allElements){
            foreach ($ids as $id) {
                $service = Service::findOrFail($id);
                Faq::where('type','service')->where('service_id',$id)->delete();
                
                if ($service->image) {
                    (file_exists(sprintf($img_path . '%s', $service->image)))?unlink(sprintf($img_path . '%s', $service->image)):'';
                }
                
                if($service->icon) {
                    (file_exists(sprintf($img_path . '%s', $service->icon)))?unlink(sprintf($img_path . '%s', $service->icon)):'';
                }
            }
            Schema::disableForeignKeyConstraints();
            Service::truncate();
            
        }else{
        
            foreach ($ids as $id) {
                $service = Service::findOrFail($id);
                Faq::where('type','service')->where('service_id',$id)->delete();
                if ($service->image) {
                    (file_exists(sprintf($img_path . '%s', $service->image)))?unlink(sprintf($img_path . '%s', $service->image)):'';
                }
                if($service->icon) {
                    (file_exists(sprintf($img_path . '%s', $service->icon)))?unlink(sprintf($img_path . '%s', $service->icon)):'';
                }
                $service->delete();
            }
        }
    }
    
    
    public function storeFaq(Request $request){
        $faq= new Faq();
        $faq->question_en = $request->question_en;
        $faq->answer_en = $request->answer_en;
        $faq->question_ar = $request->question_ar;
        $faq->answer_ar = $request->answer_ar;
        $faq->type = 'service';
        $faq->service_id = $request->service_id;
        $faq->save();
        
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return back();
    }

    public function updateFaq(Request $request){
        $faq=Faq::find($request->faq_id);
        $faq->question_en = $request->question_en;
        $faq->answer_en = $request->answer_en;
        $faq->question_ar = $request->question_ar;
        $faq->answer_ar = $request->answer_ar;
        $faq->save();
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return back();
    }
    
    public function removeFaq(){
        $faqId= $_POST['faq_id'];
        Faq::find($faqId)->delete();
    }
    
}
