<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use DB;
use App\Models\User;
use App\Models\Training;
use App\Models\Cart;
use App\Models\CartCourse;
use App\Models\OrderCourse;
use App\Models\Order;
use App\Traits\SMSTrait;
use Session;
use Mail;
use GuzzleHttp\Client;
use App\Models\Setting;
use App\Models\Configration;
use Auth;


class PlaceOrderController extends Controller
{
    //use SMSTrait;
    /////////// FUNCTION Place Order ///////////////
    public function placeOrder(Request $request){
        session(['form_data' => $request->all()]);
        
        $course_id = $request->course_id;
        $course = Training::find($course_id);
    
        $setting = Setting::first();
        $lang = \LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $user = Auth::user();

	    $total_price=$course->price;

	    //////////////// add order data to session//////////////////   
        session()->put('form_data.total_price',$total_price);
        session()->put('form_data.course_id',$course_id);
        session()->put('form_data.user_id',auth()->user()->id);
        
        /** pay with paymob*/ 
        $this->payMobPayment($total_price);
    }
    
    public function payMobPayment($total_price){
        $payMobOnlineCardIntegrationId = env('payMobOnlineCardIntegrationId'); 
        $payMobApplePayIntegrationId= env('payMobApplePayIntegrationId');
        
        $payMobsecretKey = env('payMobsecretKey');
        $payMobPublicKey= env('payMobPublicKey');
    
        $merchant_order_id = rand(11111111,99999999);
        
        $data = [
            'amount' => $total_price * 100, // Amount in cents
            'currency' => 'SAR',
            'payment_methods' => [intval($payMobOnlineCardIntegrationId) , intval($payMobApplePayIntegrationId)],
            'special_reference'=>$merchant_order_id,
            'billing_data' => [
                'apartment' => 'NA',
                'email' => Auth::user()->email ? Auth::user()->email : 'email not found!',
                'floor' => 'NA',
                'first_name' => Auth::user()->f_name,
                'street' => 'NA',
                'building' => 'NA',
                'phone_number' => 'NA',
                'postal_code' => 'NA',
                'city' => 'NA',
                'country' =>'NA',
                'last_name' => Auth::user()->l_name,
                'state' => 'NA'
            ],
            'customer' => [
                'first_name' => Auth::user()->f_name,
                'last_name' => Auth::user()->l_name,
                'email' => Auth::user()->email ? Auth::user()->email : 'email not found!',
            ],
        ];
        
        $client = new Client();
        $headers = [
            'Authorization' => 'Token '.$payMobsecretKey,
            'Content-Type' => 'application/json'
        ];

        try {
            $response = $client->post('https://ksa.paymob.com/v1/intention/', [
                'headers' => $headers,
                'json' => $data // Convert array to JSON
            ]);
            
            $body = $response->getBody();
            
            $jsonResponse = json_decode($body, true);
            
            $clientSecret = $jsonResponse['client_secret'];

            //////// insert oredr to temp orders/////
            DB::table('temp_orders')->insert([
                "merchant_order_id" =>$merchant_order_id,
                "total_price" => session('form_data')['total_price'],
                "course_id" => session('form_data')['course_id'],
                "user_id" => session('form_data')['user_id'] ?? null,
            ]);
    
            header('location: https://ksa.paymob.com/unifiedcheckout/?publicKey='.$payMobPublicKey.'&clientSecret='.$clientSecret);
            die();
            
        } catch (\GuzzleHttp\Exception\ClientException $e) {
            $responseBody = $e->getResponse()->getBody(true);
            
            echo "ClientException: " . $responseBody;
        } catch (\Exception $e) {
            echo "Exception: " . $e->getMessage();
        }
    
    }
    
    public function payMobCallback(Request $request){
        $setting = Setting::first();
        $form_data=DB::table('temp_orders')->where('merchant_order_id',$request->merchant_order_id)->first();
        $user_id = $form_data->user_id;
        $user = User::find($user_id);
        Auth::login($user);
        // if (!Session::has('form_data')) {
        //     return redirect('user/orders');
        // }
        
        
        if($request->success == "true" && $request->pending == "false"){
    
            /////// save order data//////
            $order = new Order();
            $order->user_id=$user->id;
            $order->total_price=$form_data->total_price;
            $order->status = 'paid';
            $order->save();
            
            /** order courses */
            $orderCourse = new OrderCourse();
            $orderCourse->order_id = $order->id;
            $orderCourse->course_id = $form_data->course_id;
            $orderCourse->user_id=$user->id;
            $orderCourse->save();
      
            /// delete seesion values///
            Session::forget('form_data');
            
            /////send sms after creating order////
            //$this->SendMessage($address->phone1,$setting->place_order_msg);
    
            /////////// send email to user order and admin///////
        //     $add = array('order' =>$order,'setting'=>$setting);
            
        //     Mail::send('emails/orderInfo', $add, function($msg) use ($order) {
        //       	$msg->to($order->user->email, 'Drug Station Order')->subject('Order Thanks');
        //       	$msg->from(config('mail.from.address'),config('mail.from.name'));
        //     });
           
        //   ////// notify admin with new order created /////
        //     Mail::send('emails/notifyAdminWithNewOrder', $add, function($msg) use ($setting) {
        //       	$msg->to($setting -> contact_email, 'Drug Station Order')->subject('New Order Submitted');
        //       	$msg->from(config('mail.from.address'),config('mail.from.name'));
        //     });
            
            ///// delete order date from temp orders///
            DB::table('temp_orders')->where('merchant_order_id',$request->order)->delete();

            return back()->with('success',trans('home.you are registerd in course successfully'));
        }else{
           
            return back()->with(['order_not_completed' =>trans('home.payment_faild')]);
        }
       
    }
    
}    