<?php

namespace App\Http\Controllers;

use App\Models\PartnerFront;
use App\Models\User;
use App\Models\Training;
use App\Models\Order;
use App\Models\OrderCourse;
use DB;
use File;
use Image;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use App\Helpers\Helper;

use Illuminate\Support\Facades\Http;
use Devinweb\LaravelHyperpay\Facades\LaravelHyperpay;


class PaymentController extends Controller
{
    public function prepareCheckout(Request $request)
    {
        
    //     $training = Training::where('id',$request->course_id)->first();
    // 	$url = "https://eu-test.oppwa.com/v1/checkouts";
    // 	$data = "entityId=8ac7a4c99780f4c40197829a927f0844" .
    //                 "&amount=92.00" .
    //                 "&currency=SAR" .
    //                 "&paymentType=DB" .
    //                 "&integrity=true";
    
    // 	$ch = curl_init();
    // 	curl_setopt($ch, CURLOPT_URL, $url);
    // 	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    //                   'Authorization:Bearer OGFjN2E0Yzk5NzgwZjRjNDAxOTc4Mjk2MjkzOTA4Mzh8V1l0S0tmSE1ZSHVIc1VYP3Q4WHU='));
    // 	curl_setopt($ch, CURLOPT_POST, 1);
    // 	curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    // 	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
    // 	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // 	$responseData = curl_exec($ch);
    // 	if(curl_errno($ch)) {
    // 		return curl_error($ch);
    // 	}
    // 	curl_close($ch);
    	
    // 	$responseData = json_decode($responseData);
    // 	//dd($responseData);
    // 	return view('website.checkout',compact('responseData'));
    
    $training = Training::where('id', $request->course_id)->firstOrFail();
    
    $url = "https://eu-test.oppwa.com/v1/checkouts";
    
    switch ($request->payment_method) {
        case 'mada':
            $entityId = '8ac7a4c99780f4c40197829b3d7b084a';
            $paymentBrand = 'MADA';
            break;
        case 'visa':
            $entityId = '8ac7a4c99780f4c40197829a927f0844';
            $paymentBrand = 'VISA';
            break;
        default:
            $entityId = '8ac7a4c99780f4c40197829a927f0844';
            $paymentBrand = 'VISA';
            break;
    }
    
    // Build the data string
    $data = http_build_query([
        'entityId'    => $entityId,
        'amount'      => $training->price,
        'currency'    => 'SAR',
        'paymentType' => 'DB',
        'integrity'   => 'true'  
    ]);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization:Bearer OGFjN2E0Yzk5NzgwZjRjNDAxOTc4Mjk2MjkzOTA4Mzh8V1l0S0tmSE1ZSHVIc1VYP3Q4WHU='
    ]);
    
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $responseData = curl_exec($ch);
    if (curl_errno($ch)) {
        return curl_error($ch);
    }
    curl_close($ch);
        
    $responseData = json_decode($responseData);
    

    return view('website.checkout', compact('responseData','paymentBrand','training'));

        
    }
    
    public function checkoutCallback(Request $request, Training $training,$type){
        switch ($type) {
        case 'mada':
            $entityId = '8ac7a4c99780f4c40197829b3d7b084a';
            break;
        case 'visa':
            $entityId = '8ac7a4c99780f4c40197829a927f0844';
            break;
        default:
            $entityId = '8ac7a4c99780f4c40197829a927f0844';
            break;
    }
        
        $url = "https://eu-test.oppwa.com$request->resourcePath";
        
    	$url .= "?entityId=$entityId";
    	$ch = curl_init();
    	curl_setopt($ch, CURLOPT_URL, $url);
    	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                       'Authorization:Bearer OGFjN2E0Yzk5NzgwZjRjNDAxOTc4Mjk2MjkzOTA4Mzh8V1l0S0tmSE1ZSHVIc1VYP3Q4WHU='));
    	curl_setopt($ch, CURLOPT_HTTPGET, 'GET');
    	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	$responseData = curl_exec($ch);
    	if(curl_errno($ch)) {
    		return curl_error($ch);
    	}
    	curl_close($ch);
    	$responseObject = json_decode($responseData);
        if($responseObject->result->code == '000.100.110')
        {
            $order = new Order();
            $order->user_id = auth()->user()->id;
            $order->total_price = $responseObject->amount;
            $order->payment_brand= $responseObject->paymentBrand;
            $order->status = "paid";
            $order->save();
            
            $order_course = new OrderCourse();
            $order_course->user_id = auth()->user()->id;
            $order_course->order_id = $order->id;
            $order_course->course_id= $training->id;
            $order_course->save();
            return view('website.paymet_success');
            
        }else{
            return view('website.paymet_error');
        }
    }

}