<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File as FacadesFile;
use Image;
use App\Http\Requests;
use App\Models\Center;
use App\Models\CenterHall;
use App\Models\TrainingField;
use App\Models\Course;
use App\Models\Training;
use App\Models\TrainingSchadual;
use App\Models\TrainingCourse;
use App\Models\Partner;
use App\Models\TrainingSurvey;
use App\Models\PartnerRequest;
use App\Models\PartnerNotifications;
use App\Models\PartnerTrainingRequest;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;


class PartnerController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:partners')->except(['save_partners_training_request','my_training_request','my_training_request_details','getRequestData']);
    }

    public function index()
    {
        $partners = User::with('partner')->where('type', 'partner')->where('status',1)->where('verified_partner', 1)->get();

        return view('admin.partners.index', compact('partners'));
    }
    public function edit($id)
    {
        $user = User::find($id);
        return view('admin.partners.edit', compact('user'));
    }
    
    
    public function show($id)
    {
        //
    }
    // show Form assign_partner_to_center
    public function assign_partner_to_center()
    {
        $users = User::where('type','partner')->get();
        $centers = Center::all();
        return view('admin.partners.assign_partner_to_center',compact('users','centers'));
    }
    // post action assign_partner_to_center
    public function assign_partner_to_center_action(Request $request)
    {
        $partner_check = Partner::where('user_id',$request->user)->where('center_id',$request->center)->first();
        if($partner_check){
            return back()->with(['error'=>['user'=>'Partner already asign to center']]);
        }
        Partner::create([
            'user_id'=>$request->user,
            'center_id'=>$request->center,
            'created_by' => auth()->user()->id,
            ]);
        toastr()->success(trans('home.your_item_added_successfully'), trans('home.saved'));
        return redirect()->route('partners.index');   
    }
    public function create()
    {
        $centers = Center::all();
        return view('admin.partners.create',compact('centers'));
    }
      public function store(Request $request)
    {
         $request->validate([
            'f_name' => 'required|string',
            // 'l_name' => 'required|string',
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8'],
            'mobile' => 'required',
            'image' => 'image|mimes:jpg,png,jpeg,gif,svg',
        ]);
        
        
        $token = Str::random(80);
        $add = new User();

        $add->f_name = $request->f_name;
        // $add->l_name = $request->l_name;
        $add->email = $request->email;
        $add->phone = $request->mobile;
        $add->password = bcrypt($request->password);
        $add->remember_token = $token;
        $add->type = 'partner';
        $add->status = $request->status??0;
        $add->verified_partner = $request->status ?? 0;
        $add->created_by = auth()->user()->id;

        if ($request->hasFile("image")) {
            $file = $request->file("image");
            $mime = $request->file('image')->getMimeType();
            $mimearr = explode('/', $mime);

            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path() . '/uploads/users/source/' . $fileName;

            Image::make($file->getRealPath())->save($path);

            $add->image = $fileName;
        }
        
        

        $add->save();

        if ($request->center_id){
            Partner::create(['user_id'=>$add->id,'center_id'=>$request->center_id]);
        }
        toastr()->success(trans('home.your_item_added_successfully'), trans('home.saved'));
        return redirect()->route('partners.index');   
    }

    
    public function partners_requests(){
        $partners = PartnerRequest::with('user')->get();
        foreach ($partners as $partner) {
            $partner->update(['seen' => 1]);
        }
        return view('admin.partners.partners_requests', compact('partners'));
    }
    
    public function partners_requests_change_status(Request $request){
        $partner_request = PartnerRequest::where('id',$request->id)->first();
        $user = User::where('id', $partner_request->user_id)->update(['verified_partner'=>1,'status'=>1,'updated_by' => auth()->user()->id]);
        $new_center_name = $partner_request->center_name;
        $center = Center::create([
            'name_en'=>$new_center_name,
            'name_ar'=>$new_center_name,
            'status' =>1 
            ]);
        $partner = Partner::create([
            'center_id'=>$center->id,
            'user_id'=>$partner_request->user_id,
            ]);    
        $partner_request->delete();
        
        toastr()->success(trans('home.your_item_updated_successfully'), trans('home.saved'));
        return back();    
    }
    
    public function getRequestData(Request $request){
        $code= $request->code;
        $training = Training::with('PartnerTrainingRequest','trainings_schaduals')->where('code',$code)->first();
        return response()->json($training);
    }
    
    //---------------------------------------------------
    // partner ask for add training
    public function save_partners_training_request(Request $request){
        $add = new PartnerTrainingRequest();
        $add->user_id = auth()->user()->id;
        $add->center_id = auth()->user()->partner->first()->centers()->first()->id;
        $add->hall_id = $request->hall_id;
        $add->course_ids = isset($request->courses_id) ? json_encode($request->courses_id) : null;
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->n_students = $request->n_students;
        $add->address = $request->address;
        $add->instructor_id = $request->instructor_id;
        $add->seen = 0;
        $add->alt_img = $request->alt_img;
        $add->overall_days= $request->overall_days;
        $add->overall_time= $request->overall_time;
        $add->timing_type= $request->timing_type;
        $add->time_from= $request->time_from;
        $add->time_to= $request->time_to;
        $add->start_date= $request->start_date;
        $add->end_date= $request->end_date;
        $add->training_type= $request->training_type;
        $add->request_type= $request->request_type;
        $add->exception_or_not= $request->exception_or_not;
        $add->code_to_edit= $request->code_to_edit;
        $add->online_url= $request->online_url;
        $add->training_field_id= $request->training_field_id;
        $add->recorded= $request->recorded;
        $add->view_exam= $request->view_exam;
        $add->view_survey= $request->view_survey;
        $add->created_by = auth()->user()->id;

        if($request->image){
            $add->image = Helper::uploadImage('partner_trainin_request',$request->image);
        } 
        if($request->exception_file){
            $add->exception_file = Helper::uploadFile('partner_trainin_request',$request->exception_file);
        }
        
        
        
        $add->save();
        toastr()->success(trans('home.your_item_added_successfully'), trans('home.saved'));
        return redirect()->route('my_training_request');
    }
    
    public function edit_partners_training_request(Request $request){
        $update =  PartnerTrainingRequest::find($request->id);
        $update->center_id = $request->center_id;
        $update->hall_id = $request->hall_id;
        $update->name_en = $request->name_en;
        $update->name_ar = $request->name_ar;
        $update->n_students = $request->n_students;
        $update->address = $request->address;
        $update->overall_days= $request->overall_days;
        $update->overall_time= $request->overall_time;
        $update->timing_type= $request->timing_type;
        $update->time_from= $request->time_from;
        $update->time_to= $request->time_to;
        $update->start_date= $request->start_date;
        $update->end_date= $request->end_date;
        $update->training_type= $request->training_type;
        $update->request_type= $request->request_type;
        $update->exception_or_not= $request->exception_or_not;
        $update->code_to_edit= $request->code_to_edit;
        $update->request_type= $request->request_type;
        $update->code_to_edit= $request->code_to_edit;
        $update->online_url= $request->online_url;
        $update->training_field_id= $request->training_field_id;
        $update->recorded= $request->recorded;
        $update->updated_by = auth()->user()->id;
        
        $update->save();
        // toastr()->success(trans('home.your_item_updated_successfully'), trans('home.saved'));
        return redirect()->route('partners_training_requests')->with('edit_success',trans('home.saved'));
    }
    
    public function my_training_request(){
        // return auth()->user()->id;
        $partner_requests = PartnerTrainingRequest::with(['center','instructor'])->where('user_id',auth()->user()->id)->latest()->get();
        $notifications_code = PartnerNotifications::where('user_id',auth()->user()->id)->where('seen',0)->pluck('code')->toArray();;
        if($notifications_code){
            toastr()->success(__('home.congratulations'), trans('home.accept'));
            Session::put('accepted_request', __('home.your_training_requests_has_been_accepted'));
            Session::put('accepted_code','[  '.implode(',', $notifications_code).'  ]');
            PartnerNotifications::where('user_id',auth()->user()->id)->update(['seen'=>1]);
        }
        
        return view('admin.partners.my_requests',compact('partner_requests'));
    }
    
    
    public function partners_training_requests(){
        $partner_requests = PartnerTrainingRequest::with(['center','user','hall','instructor','field'])->latest('created_at')->get();
        return view('admin.partners.partner_training_requests',compact('partner_requests'));
    }
    
    
    
    public function partner_training_request_details(Request $request){
        $partner_request = PartnerTrainingRequest::with(['center','user','hall','instructor'])->where('id',$request->partner_request_id)->first();
        $partner_request->seen = 1;
        $partner_request->save();
        $courses = Course::all();
        $centers = Center::get();
        $instructors = Center::get();
        $halls = CenterHall::get();
        $fields = TrainingField::get();
        $instructors = User::where('type','instructor')->get();
        return response()->json(['view' => view('admin.partners.partner_training_request_details', compact('partner_request','courses','centers','instructors','halls','fields'))->render()]);
    }
    
    public function my_training_request_details(Request $request){
        $partner_request = PartnerTrainingRequest::with(['center','user','hall','instructor'])->where('id',$request->my_request_id)->first();
        $courses = Course::all();
        return response()->json(['view' => view('admin.partners.my_training_request_details', compact('partner_request','courses'))->render()]);
    }
    
    public function partners_training_requests_change_status(Request $request){
        
        if($request->status == 'delivered') {
            $ids = $request->id;
            if ($ids[0] == 'on') {
                unset($ids[0]);
            }
            
            foreach ($ids as $id) {
                $partner_request = PartnerTrainingRequest::where('id',$id)->update(['status' => 'delivered']);
            }
            
        } else if($request->status == 'processing') {
            $ids = $request->id;
            if ($ids[0] == 'on') {
                unset($ids[0]);
            }
            
            foreach ($ids as $id) {
                $partner_request = PartnerTrainingRequest::where('id',$id)->update(['status' => 'processing']);
            }
        
        } else {
            $training_code = $request->training_code5 . '-' . $request->training_code3;
            $ids = $request->id;
            if ($ids[0] == 'on') {
                unset($ids[0]);
            }
            foreach ($ids as $id) {
                $partner_request = PartnerTrainingRequest::where('id',$id)->first();
                // $course_ids =json_decode($partner_request->course_ids);
                
                $training = new Training();
                $training->code = $training_code;
                $training->name_en = $partner_request->name_en;
                $training->name_ar = $partner_request->name_ar;
                $training->status = 1;
                $training->request_id = $partner_request->id;
                $training->alt_img = $partner_request->alt_img;
                $training->image = $partner_request->image;
                $training->overall_days= $partner_request->overall_days;
                $training->overall_time= $partner_request->overall_time;
                $training->timing_type= $partner_request->timing_type;
                $training->instructor_id= $partner_request->instructor_id;
                $training->time_from= $partner_request->time_from;
                $training->time_to= $partner_request->time_to;
                $training->training_type= $partner_request->training_type;
                $training->online_url= $partner_request->online_url;
                $training->training_field_id= $partner_request->training_field_id;
                $training->training_certificate= '20359.jpeg';
                $training->recorded= $partner_request->recorded;
                $training->view_exam= $partner_request->view_exam;
                $training->view_survey= $partner_request->view_survey;
                $training->created_by = auth()->user()->id;
                $training->save();
                
                $course = new Course();
                $course->name_en = $partner_request->name_en;
                $course->name_ar = $partner_request->name_ar;
                $course->code = $request->training_code5;
                $course->status = 1;
                $course->training_field_id = $partner_request->training_field_id;
                $course->created_by = auth()->user()->id;
                $course->save();
                
                $training_course = new TrainingCourse();
                $training_course->training_id = $training->id;
                $training_course->course_id = $course->id;
                $training_course->save();
                
                
                $surveys = [11,12,13];
                foreach($surveys as $survey) {
                    TrainingSurvey::create([
                        'training_id' => $add->id,
                        'survey_id' => $survey,
                        'created_by' => auth()->user()->id,
                    ]);
                }
                
                $training_schadual = new TrainingSchadual();
                $training_schadual->training_id = $training->id;
                $training_schadual->center_id = $partner_request->center_id;
                $training_schadual->hall_id = $partner_request->hall_id;
                $training_schadual->start_date = $partner_request->start_date;
                $training_schadual->end_date = $partner_request->end_date;
                $training_schadual->save();
                
                PartnerNotifications::create(['user_id'=>$partner_request->user_id,'code'=>$training_code]);
                $partner_request->update(['status' => 'accepted' , 'training_code' => $training_code]);
                // $partner_request->delete();
            }
        }
    }


    public function partners_training_edit_requests_change_status(Request $request){
        
            $ids = $request->id;
            if ($ids[0] == 'on') {
                unset($ids[0]);
            }
           
            foreach ($ids as $id) {
                $partner_request = PartnerTrainingRequest::where('id',$id)->first();
                $add = Training::where('code',$partner_request->code_to_edit)->first();
                $add->name_en = $partner_request->name_en;
                $add->name_ar = $partner_request->name_ar;
                $add->status = 1;
                $add->request_id = $partner_request->id;
                $add->alt_img = $partner_request->alt_img;
                $add->image = $partner_request->image;
                $add->overall_days= $partner_request->overall_days;
                $add->overall_time= $partner_request->overall_time;
                $add->timing_type= $partner_request->timing_type;
                $add->instructor_id= $partner_request->instructor_id;
                $add->time_from= $partner_request->time_from;
                $add->time_to= $partner_request->time_to;
                $add->training_type= $partner_request->training_type;
                $add->online_url= $partner_request->online_url;
                $add->training_field_id= $partner_request->training_field_id;
                $add->recorded= $partner_request->recorded;
                $add->view_exam= $partner_request->view_exam;
                $add->view_survey= $partner_request->view_survey;
                $add->created_by = auth()->user()->id;
                $add->save();
                
                $training_schadual = TrainingSchadual::where('training_id',$add->id)->first();
                $training_schadual->center_id = $partner_request->center_id;
                $training_schadual->hall_id = $partner_request->hall_id;
                $training_schadual->start_date = $partner_request->start_date;
                $training_schadual->end_date = $partner_request->end_date;
                $training_schadual->save();
                
                PartnerNotifications::create(['user_id'=>$partner_request->user_id,'code'=>$partner_request->code_to_edit]);
                $partner_request->update(['status' => 'edited' , 'training_code' => $partner_request->code_to_edit]);
                // $partner_request->delete();
            }
    }
    

    public function destroyTrainingRequest($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            PartnerTrainingRequest::destroy($id);
        }
    }
    
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            PartnerRequest::destroy($id);
        }
    }
    
    public function destroyPartner($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            Partner::where('center_id',$id)->delete();
        }
    }
}
