<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\NewsCategory;
use App\Helpers\Helper;

class NewsCategoryController extends Controller
{


    public function __construct()
    {
        $this->middleware('permission:blogCategory');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $newsCategories= NewsCategory::orderBy('id','desc')->get();
        return view('admin.newsCategories.newsCategories',compact('newsCategories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('admin.newsCategories.addNewsCategory');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $newscategory = new NewsCategory();
        $newscategory->name_en = $request->name_en;
        $newscategory->name_ar = $request->name_ar;
        $newscategory->link_en = str_replace(" ","-",$request->link_en);
        $newscategory->link_ar = str_replace(" ","-",$request->link_ar);
        $newscategory->text_en = $request->text_en;
        $newscategory->text_ar = $request->text_ar;
        $newscategory->status = $request->status;
        $newscategory->meta_title_en = $request->meta_title_en;
        $newscategory->meta_title_ar = $request->meta_title_ar;
        $newscategory->meta_desc_en =$request->meta_desc_en;
        $newscategory->meta_desc_ar =$request->meta_desc_ar;
        $newscategory->meta_robots =$request->meta_robots;
        $newscategory->save();
        
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('news-categories.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $newsCategory = NewsCategory::find($id);
        if($newsCategory){
            return view('admin.newsCategories.editNewsCategory',compact('newsCategory'));
        }else{
            abort('404');
        }
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        //
        $newscategory = NewsCategory::find($id);
        $newscategory->name_en = $request->name_en;
        $newscategory->name_ar = $request->name_ar;
        $newscategory->link_en = str_replace(" ","-",$request->link_en);
        $newscategory->link_ar = str_replace(" ","-",$request->link_ar);
        $newscategory->text_en = $request->text_en;
        $newscategory->text_ar = $request->text_ar;
        $newscategory->status = $request->status;
        
        $newscategory->meta_title_en = $request->meta_title_en;
        $newscategory->meta_title_ar = $request->meta_title_ar;
        $newscategory->meta_desc_en =$request->meta_desc_en;
        $newscategory->meta_desc_ar =$request->meta_desc_ar;
        $newscategory->meta_robots =$request->meta_robots;
        $newscategory->save();
        
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return redirect()->route('news-categories.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        if($allElements){
            NewsCategory::truncate();
        }else{
        
            foreach ($ids as $id) {
                $newscategory = NewsCategory::findOrFail($id);
                $newscategory->delete();
            }
        }
    }
}
