<?php

namespace App\Http\Controllers;

use App\Models\Center;
use App\Models\CenterHall;
use App\Models\Training;
use App\Models\User;
use App\Models\Course;
use App\Models\TrainingSchadual;
use App\Models\TrainingCourse;
use App\Models\Instructor;
use App\Models\Student;
use App\Models\StudentAddress;
use App\Models\StudentInfo;
use App\Models\Region;
use App\Models\Survey;
use Spatie\Permission\Models\Role;
use App\Jobs\SendSmsJob;
use App\Jobs\SendWhatsappJob;
use DB;
use Artisan;
use DateTime;
use Session;
use Carbon\Carbon;

use Illuminate\Http\Request;

class MessageController extends Controller
{

    public function index(){
        $trainings = Training::get();
        return view('admin.messages.index',compact('trainings'));
    }
    
    public function sendWhatsappMessages(Request $request){
        $training = Training::where('id',$request->trainingId)->first();
        if($training){
            $contacts = [];
            $students = $training->students;
            foreach($students as $student) {
                if(isset($student->studentinfo->mobile)) {
                    $contacts[] = $student->studentinfo->mobile;
                }
            }
            
            
            // (count($contacts)) ? $chunks = array_chunk($contacts, 20) : $chunks = $contacts;

            foreach ($contacts as $i => $contact) {
                if(substr($contact, 0, 1) === '5') {
                    $contact = "966".$contact;
                } else if(substr($contact, 0, 2) === '05') {
                    $contact = "966".substr($contact, 1);;
                } else {
                    continue;
                }
                $job = (new SendWhatsappJob($contact, $request->message))->delay(\Carbon\Carbon::now()->addSeconds(5));
                dispatch($job);
            }
        }
        
        
        $output = shell_exec("ps aux | grep 'php artisan queue:work' | grep -v grep");
        if(!isset($output)){
            Artisan::call('queue:work', ['--stop-when-empty' => true]);
        }
        return 'alert success';
        
    }
    
    public function sendSMSMessages(Request $request){
        $training = Training::where('id',$request->trainingId)->first();
        if($training){
            $contacts = [];
            $students = $training->students;
            foreach($students as $student) {
                if(isset($student->studentinfo->mobile)) {
                    if(substr($student->studentinfo->mobile, 0, 1) === '5') {
                        $contacts[] = "966".$student->studentinfo->mobile;
                    } else if(substr($student->studentinfo->mobile, 0, 2) === '05') {
                        $contacts[] = "966".substr($student->studentinfo->mobile, 1);;
                    } else {
                        continue;
                    }
                }
            }
            
            (count($contacts)) ? $chunks = array_chunk($contacts, 50) : $chunks = $contacts;

            foreach ($chunks as $chunk) {
                $job = (new SendSmsJob($chunk, $request->message))->delay(\Carbon\Carbon::now()->addSeconds(5));
                dispatch($job);
            }
            
        }
        $output = shell_exec("ps aux | grep 'php artisan queue:work' | grep -v grep");
        if(!isset($output)){
            Artisan::call('queue:work', ['--stop-when-empty' => true]);
        }
        return 'alert success';
    }
    
    public function sendEmails(Request $request){
        $training = Training::where('id',$request->trainingId)->first();
        if($training){
            $contacts = [];
            $students = $training->students;
            foreach($students as $student) {
                if(isset($student->user->email)) {
                    $contacts[] = $student->user->email;
                }
            }
            
            (count($contacts)) ? $chunks = array_chunk($contacts, 50) : $chunks = $contacts;

            foreach ($chunks as $chunk) {
                $job = (new SendEmail("mohamed25369921@gmail.com", $message))->delay(\Carbon\Carbon::now()->addSeconds(5));
                dispatch($job);
            }
            
        }
        $output = shell_exec("ps aux | grep 'php artisan queue:work' | grep -v grep");
        if(!isset($output)){
            Artisan::call('queue:work', ['--stop-when-empty' => true]);
        }
        return 'alert success';
    }
    
}
