<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Imports\CourseImport;
use Illuminate\Http\Request;
use Symfony\Component\Intl\Countries;

use App\Models\TrainingCourse;
use App\Models\TrainingExam;
use App\Models\Training;
use App\Models\Exame;
use App\Models\InstructorInfo;
use App\Models\Course;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\DB;
class ExameController extends Controller
{

    public function __construct()
    {
        // $this->middleware('permission:exames');
    }

    public function index()
    {
        if(auth()->user()->type=="instructor"){
            // $instructor_id = InstructorInfo::where('user_id',auth()->user()->id)->first()->id;
            $training_ids = TrainingCourse::where('instructor_id',auth()->user()->id)->pluck('training_id')->toArray();
            $exam_ids = TrainingExam::whereIn('training_id',$training_ids)->pluck('exam_id')->toArray();
            $exames = Exame::whereIn('id',$exam_ids)->get();
        }else {
            $exames = Exame::all();
        }
        return view('admin.exames.index', compact('exames'));
    }


    public function create()
    {
        $courses = Course::all();
        return view('admin.exames.create',compact('courses'));
    }

  
    public function store(Request $request)
    {
        $request->validate([
            'name_en' => 'required|string',
            'name_ar' => 'required|string',
            'duration' => 'required|string',
            'course' => 'required',
            'average_rate' => 'required|string',
        ]);

        $add = new Exame();
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->duration = $request->duration;
        $add->course_id = $request->course;
        $add->average_rate = $request->average_rate;
        $add->status = $request->status??0;
        $add->created_by = auth()->user()->id;
        $add->save();

        toastr()->success(trans('home.your_item_added_successfully'), trans('home.saved'));
        return redirect()->route('exames.index');
    }



    public function edit($id)
    {
        $exame = Exame::find($id);
        $courses = Course::all();
        if ($exame) {
            return view('admin.exames.edit', compact('exame','courses'));
        } else {
            abort('views.404');
        }
    }

    public function update(Request $request, $id)
    {
         $request->validate([
            'name_en' => 'required|string',
            'name_ar' => 'required|string',
            'duration' => 'required|string',
            'course' => 'required',
            'average_rate' => 'required|string',
        ]);

        $add = Exame::find($id);
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->duration = $request->duration;
        $add->course_id = $request->course;
        $add->average_rate = $request->average_rate;
        $add->status = $request->status??0;
        $add->updated_by = auth()->user()->id;
        $add->save();


        toastr()->success(trans('home.your_item_updated_successfully'), trans('home.updated'));
        return redirect()->route('exames.index');
    }

    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        if($allElements){
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
            Exame::truncate();
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
            
        }else{
            foreach ($ids as $id) {
                Exame::findOrFail($id)->delete();
            }
        }
    }  
    
    // results -------------------------------
    public function exame_results(){
        $today = \Carbon\Carbon::now()->toDateString();
        $trainings = Training::with('exame','exame.exame_details','exame.exame_results_admin')->where('view_exam', '<=', $today)->get();
        return view('admin.exameResults.index',compact('trainings'));
    }
    public function exame_results_details($training_id){
        $training = Training::where('id',$training_id)->with('exame','exame.exame_details','exame.exame_results_admin','exame.exame_results_admin.user','exame.exame_results_admin.user.student_info')->first();
        return view('admin.exameResults.show',compact('training'));
    }
    
    
    
    
    
 
}
