<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\CrmClient;
use App\Models\CrmTarget;
use Illuminate\Support\Str;
use DB;
use File;
use Image;
use App\Helpers\Helper;
use Illuminate\Support\Facades\Validator;


class CrmTargetController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:crm');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $targets = CrmTarget::get();
        return view('admin.crm.targets.index', compact('targets'));
    }
    public function create()
    {
        return view('admin.crm.targets.create');
    }
    public function store(Request $request)
    {
        CrmTarget::create($request->all());
        toastr()->success(trans('home.your_item_added_successfully'), trans('home.updated'));
        return redirect('admin/crm/crm-employess/targets');
    }
    public function update(Request $request,CrmTarget $target)
    {
        $target->update($request->all());
        toastr()->success(trans('home.your_item_updated_successfully'), trans('home.updated'));
        return redirect('admin/crm/crm-employess/targets');
    }
    
    
    public function show(CrmTarget $target)
    {
        return view('admin.crm.targets.edit', compact('target'));
    }
    
    
    public function delete(CrmTarget $target)
    {
        $target->delete();
        toastr()->success(trans('home.your_item_deleted_successfully'), trans('home.updated'));
        return redirect('admin/crm/crm-employess/targets');
    }
    

}
