<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Region;
use App\Models\Area;
use App\Models\Country;
use App\Models\CrmTarget;
use Illuminate\Support\Str;
use DB;
use File;
use Image;
use App\Helpers\Helper;
use Illuminate\Support\Facades\Validator;


class CrmEmployeeController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:crm');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = User::where('type','crm_employee')->get();
        return view('admin.crm.employees.users', compact('users'));
    }
    public function create()
    {
        $targets = CrmTarget::all();
        $countries = Country::get();
        $areas = Area::get();
        $regions = Region::get();
        return view('admin.crm.employees.create', compact('targets','countries','areas','regions'));
    }
    public function store(Request $request)
    {
        $token = Str::random(80);
        $add = new User();

        $add->f_name = $request->f_name;
        $add->l_name = $request->l_name;
        $add->email = $request->email;
        $add->phone = $request->phone;
        $add->password = bcrypt($request->password);
        $add->remember_token = $token;
        $add->is_admin = $request->type == 'admin' ? 1:0;
        $add->is_admin = in_array($request->type,['admin','crm_employee'])?1:0;
        $add->type = "crm_employee";
        $add->country_id = $request->country_id;
        $add->region_id = $request->region_id;
        $add->area_id = $request->area_id;
        $add->status = $request->status;
        $add->target_type = $request->target_type;
        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/users/source/' . $fileName);
            $resize200 = base_path('uploads/users/resize200/' . $fileName);
            $resize800 = base_path('uploads/users/resize800/' . $fileName);
            //  $file->move($destinationPath, $fileName);

            Image::make($file->getRealPath())->save($path);

            $arrayimage = list($width, $height) = getimagesize($file->getRealPath());
            $widthreal = $arrayimage['0'];
            $heightreal = $arrayimage['1'];

            $width200 = ($widthreal / $heightreal) * 200;
            $height200 = $width200 / ($widthreal / $heightreal);

            $img200 = Image::canvas($width200, $height200);
            $image200 = Image::make($file->getRealPath())->resize($width200, $height200, function ($c) {
                $c->aspectRatio();
                $c->upsize();
            });
            $img200->insert($image200, 'center');
            $img200->save($resize200);

            $width800 = ($widthreal / $heightreal) * 800;
            $height800 = $width800 / ($widthreal / $heightreal);

            $img800 = Image::canvas($width800, $height800);
            $image800 = Image::make($file->getRealPath())->resize($width800, $height800, function ($c) {
                $c->aspectRatio();
                $c->upsize();
            });
            $img800->insert($image800, 'center');
            $img800->save($resize800);

            $add->image = $fileName;
        }

        $add->save();

        $add->assignRole(13);
        toastr()->success(trans('home.your_item_added_successfully'), trans('home.updated'));
        return redirect('admin/crm/crm-employess');
    }
    public function update(Request $request,User $user)
    {
        $user->is_admin = in_array($request->type,['admin','crm_employee'])?1:0;
        $user->f_name = $request->f_name;
        $user->l_name = $request->l_name;
        $user->email = $request->email;
        $user->phone = $request->phone;
        $user->type = $request->type;
        $user->country_id = $request->country_id;
        $user->region_id = $request->region_id;
        $user->area_id = $request->area_id;
        $user->status = $request->status;
        $user->target_type = $request->target_type;
        if ($request->password) {
            $user->password = bcrypt($request->password);
        }

        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $img_path = base_path() . '/uploads/users/source/';
            $img_path200 = base_path() . '/uploads/users/resize200/';
            $img_path800 = base_path() . '/uploads/users/resize800/';

            if ($update->image != null) {
                unlink(sprintf($img_path . '%s', $update->image));
                unlink(sprintf($img_path200 . '%s', $update->image));
                unlink(sprintf($img_path800 . '%s', $update->image));
            }
            
            // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/users/source/' . $fileName);
            $resize200 = base_path('uploads/users/resize200/' . $fileName);
            $resize800 = base_path('uploads/users/resize800/' . $fileName);
            //  $file->move($destinationPath, $fileName);

            Image::make($file->getRealPath())->save($path);

            $arrayimage = list($width, $height) = getimagesize($file->getRealPath());
            $widthreal = $arrayimage['0'];
            $heightreal = $arrayimage['1'];

            $width200 = ($widthreal / $heightreal) * 200;
            $height200 = $width200 / ($widthreal / $heightreal);

            $img200 = Image::canvas($width200, $height200);
            $image200 = Image::make($file->getRealPath())->resize($width200, $height200, function ($c) {
                $c->aspectRatio();
                $c->upsize();
            });
            $img200->insert($image200, 'center');
            $img200->save($resize200);

            $width800 = ($widthreal / $heightreal) * 800;
            $height800 = $width800 / ($widthreal / $heightreal);

            $img800 = Image::canvas($width800, $height800);
            $image800 = Image::make($file->getRealPath())->resize($width800, $height800, function ($c) {
                $c->aspectRatio();
                $c->upsize();
            });
            $img800->insert($image800, 'center');
            $img800->save($resize800);

            $user->image = $fileName;
        }

        $user->save();
        
        
        toastr()->success(trans('home.your_item_updated_successfully'), trans('home.updated'));
        return redirect('admin/crm/crm-employess');
    }
    
    
    public function show(User $user)
    {
        $targets = CrmTarget::all();
        $countries = Country::get();
        $areas = Area::get();
        $regions = Region::get();
        return view('admin.crm.employees.edit', compact('user','targets','countries','areas','regions'));
    }
    
    
    public function delete(User $user)
    {
        $user->delete();
        toastr()->success(trans('home.your_item_deleted_successfully'), trans('home.updated'));
    }
    

}
