<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\CoursePoint;
use App\Models\CourseMaterial;
use App\Models\CourseRequirment;
use App\Models\Level;
use App\Models\Teacher;
use Illuminate\Http\Request;
use App\Models\Course;
use App\Models\Type;
use File;
use Image;
class CourseFeaturesController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('permission:course-features');
    }

    public function index()
    {
        $points = CoursePoint::get();
        $materials = CourseMaterial::get();
        $requirments = CourseRequirment::get();
        return view('admin.coursesFeatures.editcoursesFeatures',compact('points','materials','requirments'));
    }

    public function updateCourseFeatureItem(Request $request){
        if($request->type=="point"){
            $updated_item = CoursePoint::where('id',$request->item_id)->first();
        }elseif($request->type=="material"){
            $updated_item = CourseMaterial::where('id',$request->item_id)->first();
        }else{
            $updated_item = CourseRequirment::where('id',$request->item_id)->first();
        }
        $updated_item->text_en = $request->text_en;
        $updated_item->text_ar = $request->text_ar;
        $updated_item->save();
        return redirect('admin/course-features')->with('success',trans('home.your_item_updated_successfully'));
    }

    public function edit($id){
        $course = Course::find($id);
        if($course){
            return view('admin.teachers.editCourse',compact('teacher'));
        }
        else{
            abort('404');
        }
    }
    public function update(Request $request){


      // pointe to learn
        $point_ars = $request->point_ar;
        if($point_ars){
            $point_ars_count = count($point_ars);
            foreach($request->point_en as $index_point=>$point_en){
                CoursePoint::create([
                    'text_en'=> $point_en,
                    'text_ar'=> $point_ars_count>=$index_point+1?$point_ars[$index_point]:$point_en,
                ]);
            }
        }

        // material to include
        $material_ars = $request->material_ar;
        if($material_ars){
            $material_ars_count = count($material_ars);
            foreach($request->material_en as $index_point=>$material_en){
                CourseMaterial::create([
                    'text_en'=> $material_en,
                    'text_ar'=> $material_ars_count>=$index_point+1?$material_ars[$index_point]:$material_en,
                ]);
            }
        }
        
        // course requirments
        $require_ars = $request->require_ar;
        if($require_ars){
            $require_ars_count = count($require_ars);
            foreach($request->require_en as $index_point=>$require_en){
                CourseRequirment::create([
                    'text_en'=> $require_en,
                    'text_ar'=> $require_ars_count>$index_point+1?$require_ars[$index_point]:$require_en,
                ]);
            }
        }




        return redirect('admin/course-features')->with('success',trans('home.your_item_updated_successfully'));
    }
    public function show(){
        //
    }

    public function removeCourseFeature(Request $request)
    {
        if($request->type=="point"){
            $deleted_item = CoursePoint::where('id',$request->id)->first();
        }elseif($request->type=="material"){
            $deleted_item = CourseMaterial::where('id',$request->id)->first();
        }else{
            $deleted_item = CourseRequirment::where('id',$request->id)->first();
        }
        $deleted_item->delete();
        return redirect('admin/course-features')->with('success',trans('home.your_item_updated_successfully'));
        
    }

    


}
