<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Chapter;
use App\Models\CourseDiscount;
use App\Models\CoursePoint;
use App\Models\CourseMaterial;
use App\Models\CourseRequirment;
use App\Models\Level;
use App\Models\Teacher;
use Illuminate\Http\Request;
use App\Models\Course;
use App\Models\Type;
use File;
use Image;
class CourseController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('permission:courses');
    }

    public function index()
    {
        $courses =Course::with('chapters')->get();
        return view('admin.courses.courses',compact('courses'));
    }
    public function create()
    {
        return view('admin.courses.addCourse');
    }
    public function store(Request $request){
        $course = new Course();
        $course->name_en = $request->name_en;
        $course->name_ar = $request->name_ar;
        $course->text_ar = $request->text_ar;
        $course->text_en = $request->text_en;
        $course->status = $request->status??0;
        $course->save();
        return redirect('admin/courses')->with('success',trans('home.your_item_added_successfully'));

    }
    public function edit($id){
        $course = Course::findOrFail($id);
        return view('admin.courses.editCourse',compact('course'));
    }
    
    public function show($id){
        $courses =Course::with('chapters')->findOrFail($id);
        return view('admin.courses.courses',compact('courses'));
    }

    public function update(Request $request, $id){
        $course = Course::find($id);
        $course->name_en = $request->name_en;
        $course->name_ar = $request->name_ar;
        $course->text_ar = $request->text_ar;
        $course->text_en = $request->text_en;
        $course->status = $request->status??0;
        $course->save();
        
        return redirect('admin/courses')->with('success',trans('home.your_item_updated_successfully'));
    }
    public function course_chapters($course_id){
        $chapters =Chapter::where('course_id',$course_id)->get();
        return view('admin.chapters.chapters',compact('chapters'));
    }

    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            $m = Course::findOrFail($id);
            $m->delete();
        }
    }

    // public function getChapters(Request $request){
    //     $course=Course::with('type')->where('id',$request->course_id)->first();
    //     $chapters = Chapter::where('course_id',$request->course_id)->get();
    //     return response()->json(['type_id'=>$course->type_id,'type'=>$course->type,'chapters'=>$chapters]);
    // }

    public function getChapters(Request $request){
        $chapters = Chapter::where('course_id',$request->course_id)->get();
        return response()->json($chapters);
    }

    public static function convertToEmbedUrl($url)
    {
        $urlParts = parse_url($url);
        parse_str($urlParts['query'], $queryParams);
        
        $videoId = $queryParams['v'] ?? null;
        $abChannel = $queryParams['ab_channel'] ?? null;

        if ($videoId) {
            $embedUrl = "https://www.youtube.com/embed/{$videoId}";
            if ($abChannel) {
                $embedUrl .= "?&ab_channel={$abChannel}";
            }
            return $embedUrl;
        }

        return $url; // Return original URL if conversion fails
    }


}
