<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Configration;
use File;
use Image;
use App\Helpers\Helper;
class ConfigrationController extends Controller
{
    
    public function __construct(){
        $this->middleware(['permission:configration']);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function show($lang)
    {
        //
        $configrations =Configration::where('lang',$lang)->first();
        return view('admin.configrations.configration',compact('configrations'));
    }


    public function update(Request $request, $lang)
    {
        $configration = Configration::where('lang',$lang)->first();
        $configration->app_name = $request->app_name;
        $configration->about_app = $request->about_app;
        $configration->copy_rights_text = $request->copy_rights_text;

        if($configration->app_logo && $request->app_logo){
            $configration->app_logo = Helper::updateUploadedImage('settings',$request->app_logo ,$configration->app_logo);
        }elseif($request->app_logo){
            $configration->app_logo = Helper::uploadImage('settings',$request->app_logo);
        } 

        if($configration->footer_logo && $request->footer_logo){
            $configration->footer_logo = Helper::updateUploadedImage('settings',$request->footer_logo ,$configration->footer_logo);
        }elseif($request->footer_logo){
            $configration->footer_logo = Helper::uploadImage('settings',$request->footer_logo);
        } 

        if($configration->fav_icon && $request->fav_icon){
            $configration->fav_icon = Helper::updateUploadedImage('settings',$request->fav_icon ,$configration->fav_icon);
        }elseif($request->fav_icon){
            $configration->fav_icon = Helper::uploadImage('settings',$request->fav_icon);
        } 
        $configration->updated_by = auth()->user()->id;
        $configration->save() ;
        
        toastr()->success(trans('home.configurations_updated_successfully') , trans('home.updated'));
        return back();
    }
}
