<?php

namespace App\Http\Controllers;

use App\Models\GuestCart;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\OrderProduct;
use DB;
use Auth;
use App\Models\Address;
use App\Models\Order;
use App\Models\Cart;
use App\Models\CartProduct;
use App\Models\Coupon;
use App\Models\CouponProduct;
use App\Models\CouponCategory;
use App\Models\CouponBrand;
use App\Models\CouponUser;
use App\Models\CouponRegion;
use App\Models\CouponShipping;
use Carbon\Carbon;


class CheckCouponController extends Controller
{
    /////////// FUNCTION CHECK COUPON ////////////
    public function applyCoupon(){
        $couponCode=$_POST['coupon_code'];
        $checkCoupon=Coupon::where('code',$couponCode)->first();
        if(Auth::check()){
            $userCart=Cart::where('user_id',Auth::user()->id)->first();
        }else{
            $userCart=GuestCart::where('user_id',Auth::user()->id)->first();
        }
        $cartCouponProductsCount=0;
        $discount = 0;
        if(!$checkCoupon){
            $couponStatus=trans('home.Sorry Coupon Not Found !');
            $check_coupon_status='error';
        }else{
            if($userCart->coupon_id == $checkCoupon->id){
                $couponStatus= trans('home.This Coupon already in use');
                $check_coupon_status='error';
            }else{
                if($checkCoupon->expire_date < Carbon::now()->format('Y-m-d')){
                    $couponStatus=trans('home.Sorry this is Expired Coupon');
                    $check_coupon_status='error';
                }else{
                    if($checkCoupon->used_count ==$checkCoupon->max_used){
                        $check_coupon_status='error';
                        $couponStatus=trans('home.Sorry Coupon has been reached to maximum use');
                    }else{
                        if($checkCoupon->value_type == 'value'){
                            $discount= $checkCoupon->value ;
                        }else{
                            $discount=((($userCart->products_price  * $checkCoupon->value) / 100 ));
                        }
                        ///// apply coupon to cart///////
                        $userCart->coupon_id=$checkCoupon->id;
                        $userCart->coupon_discount=$discount;
                        $userCart->total_price=$userCart->total_price - $discount;
                        $userCart->save();

                        $couponStatus=trans('home.Coupon used Successfully !');
                        \Session::put('check_coupon',$couponStatus);
                        \Session::put('check_coupon_status','success');

                        return response()->json([$couponStatus,$discount]);
                    }
                }
            }
        }
        
        \Session::put('check_coupon',$couponStatus);
        \Session::put('check_coupon_status',$check_coupon_status);
        return response()->json([$couponStatus,$discount,$cartCouponProductsCount]);

    }
}
