<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Chapter;
use App\Models\CoursePoint;
use App\Models\CourseMaterial;
use App\Models\CourseRequirment;
use App\Models\Level;
use App\Models\Lesson;
use App\Models\Teacher;
use Illuminate\Http\Request;
use App\Models\Course;
use App\Models\Type;
use File;
use Image;
class ChapterController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('permission:chapters');
    }

    public function index()
    {
        $chapters =Chapter::get();
        return view('admin.chapters.chapters',compact('chapters'));
    }

    public function chapter_lessons($chapter_id){
        $lessons = Lesson::with('chapter', 'course')->where('chapter_id',$chapter_id)->get();
        return view('admin.lessons.lessons', compact('lessons'));
    }

    public function create()
    {
        $courses = Course::get();

        return view('admin.chapters.addChapter',compact('courses'));
    }

    public function store(Request $request){
        $request->validate([
          'course_id' => 'required'
        ]);
        $chapter = new Chapter();
        $chapter->name_en = $request->name_en;
        $chapter->name_ar = $request->name_ar;
        $chapter->course_id = $request->course_id;
        $chapter->duration = $request->duration;
        $chapter->order = $request->order;
        $chapter->status = $request->status??0;
        $chapter->free = $request->free??0;
        $chapter->save();
        return redirect('admin/chapters')->with('success',trans('home.your_item_added_successfully'));
    }
    public function edit($id){
        $chapter = Chapter::find($id);
        if($chapter){
            $courses = Course::get();
            return view('admin.chapters.editChapter',compact('chapter','courses'));
        }
        else{
            abort('404');
        }
    }

    public function update(Request $request, $id){
        $request->validate([
            'course_id' => 'required'
        ]);
        $chapter = Chapter::find($id);
        Lesson::where('course_id',$chapter->course_id)->update(['course_id'=>$request->course_id]);
        $chapter->name_en = $request->name_en;
        $chapter->name_ar = $request->name_ar;
        $chapter->course_id = $request->course_id;
        $chapter->duration = $request->duration;
        $chapter->order = $request->order;
        $chapter->status = $request->status??0;
        $chapter->free = $request->free??0;
        $chapter->save();
        
        return redirect('admin/chapters')->with('success',trans('home.your_item_updated_successfully'));
    }
    public function show(){
        //
    }

    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            $m = Chapter::findOrFail($id);
            $m->delete();
        }
    }

    


}
