<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Center;
use App\Models\InstructorInfo;
use App\Models\TrainingSchadual;
use App\Models\TrainingCourse;
use App\Models\CenterResponsible;
use App\Models\Training;
use App\Models\Partner;
use App\Models\Country;
use App\Models\Region;
use App\Models\SurvayResult;
use App\Models\Area;
use App\Models\User;
use App\Imports\CenterImport;
use App\DataTables\CenterDataTable;
use Maatwebsite\Excel\Facades\Excel;


class CenterController extends Controller
{

    public function __construct()
    {
        // $this->middleware('permission:centers');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(CenterDataTable $dataTable)
    {
        //  $center = Center::find(7);
        // return  $center->courses_count();
        // if(auth()->user()->type=="partner"){
        //     $center_ids =Partner::where('user_id',auth()->user()->id)->pluck('center_id')->toArray();
        //     $centers = Center::whereIn('id',$center_ids)->get();
        // }
        // else if(auth()->user()->type=="instructor"){
        //     // $instructor_id = InstructorInfo::where('user_id',auth()->user()->id)->first()->id;
        //     $training_ids = TrainingCourse::where('instructor_id',auth()->user()->id)->pluck('training_id')->toArray();
        //     $center_ids = TrainingSchadual::whereIn('training_id',$training_ids)->pluck('center_id')->toArray();
        //     $centers = Center::whereIn('id',$center_ids)->orderBy('id','DESC')->where('status',1)->get();
        // }
        // else if(auth()->user()->type=="coordinator"){
        //     $training_ids = Training::where('coordinator_id',auth()->user()->id)->pluck('id')->toArray();
        //     $center_ids = TrainingSchadual::whereIn('training_id',$training_ids)->pluck('center_id')->toArray();
        //     $centers = Center::whereIn('id',$center_ids)->orderBy('id','DESC')->where('status',1)->get();
        // }
        // else if(auth()->user()->type=="marketer"){
        //     $training_ids = Training::where('marketer_id',auth()->user()->id)->pluck('id')->toArray();
        //     $center_ids = TrainingSchadual::whereIn('training_id',$training_ids)->pluck('center_id')->toArray();
        //     $centers = Center::whereIn('id',$center_ids)->orderBy('id','DESC')->where('status',1)->get();
        // }else{
        //     $centers = Center::all();
        // }
        // return view('admin.centers.centers', compact('centers'));
        
        return $dataTable->render('admin.centers.index_copy');
    }

     public function schedule_centers($center_id=null)
    {
        $centers_selectors = Center::where('status',1)->get();
        
        if(auth()->user()->type=="partner"){
            // $centers = auth()->user()->partner->centers()->with('trainingsSchadual')->get();
            $center_ids =Partner::where('user_id',auth()->user()->id)->pluck('center_id')->toArray();
            $centers = Center::with(['trainingsSchadual'])->whereIn('id',$center_ids)->orderBy('id','DESC')->where('status',1)->get();

        }
        else if(auth()->user()->type=="instructor"){
            // $instructor_id = InstructorInfo::where('user_id',auth()->user()->id)->first()->id;
            $training_ids = TrainingCourse::where('instructor_id',auth()->user()->id)->pluck('training_id')->toArray();
            $center_ids = TrainingSchadual::whereIn('training_id',$training_ids)->pluck('center_id')->toArray();
            $centers = Center::with(['trainingsSchadual'])->whereIn('id',$center_ids)->orderBy('id','DESC')->where('status',1)->get();
        }
        else if(auth()->user()->type=="coordinator"){
            $training_ids = Training::where('coordinator_id',auth()->user()->id)->pluck('id')->toArray();
            $center_ids = TrainingSchadual::whereIn('training_id',$training_ids)->pluck('center_id')->toArray();
            $centers = Center::with(['trainingsSchadual' => function ($query) use ($training_ids) {
                            $query->whereIn('training_id', $training_ids);
                        }])->whereIn('id',$center_ids)->orderBy('id','DESC')->where('status',1)->get();
        }
        else if(auth()->user()->type=="marketer"){
            $training_ids = Training::where('marketer_id',auth()->user()->id)->pluck('id')->toArray();
            $center_ids = TrainingSchadual::whereIn('training_id',$training_ids)->pluck('center_id')->toArray();
            $centers = Center::with(['trainingsSchadual' => function ($query) use ($training_ids) {
                            $query->whereIn('training_id', $training_ids);
                        }])->whereIn('id',$center_ids)->orderBy('id','DESC')->where('status',1)->get();
        }else{
            $centers = Center::with('trainingsSchadual')->where('status',1)->get();
        }
        
        if($center_id && $center_id!="all"){
            $centers = $centers->where('id',$center_id);
        }

        return view('admin.centers.schedule_centers', compact('centers','centers_selectors'));
    }
    
    public function create()
    {
        $countries = Country::get();
        $responsibles = User::where('type','admin')->orWhere('type','coordinator')->get();
        return view('admin.centers.addCenter',compact('countries','responsibles'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // return $request;
        $request->validate([
            'name_en' => 'required|string',
            'name_ar' => 'required|string',
            // 'country_id' => 'required',
            // 'region_id' => 'required',
            // 'area_id' => 'required',
            'map_url' => 'required|string',
            'logo' => 'sometimes|image|mimes:jpg,png,jpeg,gif,webp',
        ]);

        $add = new Center();
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->country_id = $request->country_id;
        $add->region_id = $request->region_id;
        $add->area_id = $request->area_id;
        $add->map_url = $request->map_url;
        $add->partner_start_date = $request->partner_start_date;
        $add->status = $request->status;
        $add->responsible_of_contact = $request->responsible_of_contact; 
        $add->created_by = auth()->user()->id;
        if ($request->logo) {
            $add->logo = Helper::uploadImage('centers', $request->logo);
        }
        if ($request->hasFile('identity_attachment')) {
            $add->identity_attachment  = Helper::uploadFile('centers/attachments',$request->identity_attachment);
        }
        if ($request->hasFile('national_address')) {
            $add->national_address  = Helper::uploadFile('centers/attachments',$request->national_address);
        }
        if ($request->hasFile('profile_attachment')) {
            $add->profile_attachment  = Helper::uploadFile('centers/attachments',$request->profile_attachment);
        }
        $add->save();
        
        $responsibles_name =$request->responsible_name;
        if($responsibles_name){
            $responsibles_job=$request->responsible_job;
            $responsibles_email=$request->responsible_email;
            $responsibles_phone=$request->responsible_phone;
            $responsibles_whatsapp=$request->responsible_whatsapp;
            
            foreach($responsibles_name as $key=>$responsible_name){
                if($responsible_name && $responsibles_job[$key]){

                    $responsible = new CenterResponsible();
                    $responsible->center_id = $add->id;
                    $responsible->responsible_name = $responsible_name;
                    $responsible->responsible_job = $responsibles_job[$key];
                    $responsible->responsible_email = $responsibles_email[$key];
                    $responsible->responsible_phone = $responsibles_phone[$key];
                    $responsible->responsible_whatsapp = $responsibles_whatsapp[$key];
                    $responsible->created_by = auth()->user()->id;
                    $responsible->save();
                }
            }
        }
        
        /////match partener with center////
        if(auth()->user()->type=="partner"){
            Partner::create([
                'user_id'=>auth()->user()->id,
                'center_id'=>$add->id,
            ]);
        }

        toastr()->success(trans('home.your_item_saved_successfully'), trans('home.saved'));
        return redirect()->route('centers.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $responsibles = User::where('type','admin')->orWhere('type','coordinator')->get();
        $center_resposibles = CenterResponsible::where('center_id',$id)->get();
        $center = Center::find($id);
        if ($center) {
            $countries = Country::get();
            $regions = Region::get();
            $areas = Area::get();
            return view('admin.centers.editCenter', compact('center','countries','regions','areas','responsibles','center_resposibles'));
        } else {
            abort('views.404');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        $request->validate([
            'name_en' => 'required|string',
            'name_ar' => 'required|string',
            // 'country_id' => 'required',
            // 'region_id' => 'required',
            // 'area_id' => 'required',
            'map_url' => 'required|string',
            'logo' => 'sometimes|image|mimes:jpg,png,jpeg,gif,svg',
        ]);
        $updated = Center::findOrFail($id);

        $updated->name_en = $request->name_en;
        $updated->name_ar = $request->name_ar;
        $updated->text_en = $request->text_en;
        $updated->text_ar = $request->text_ar;
        $updated->country_id = $request->country_id;
        $updated->region_id = $request->region_id;
        $updated->area_id = $request->area_id;
        $updated->partner_start_date = $request->partner_start_date;
        $updated->map_url = $request->map_url;
        $updated->status = $request->status;
        $updated->responsible_of_contact = $request->responsible_of_contact; 
        $updated->updated_by = auth()->user()->id;
        
        if ($updated->logo && $request->logo) {
            $updated->logo = Helper::updateUploadedImage('centers', $request->logo, $updated->logo);
        } elseif ($request->logo) {
            $updated->logo = Helper::uploadImage('centers', $request->logo);
        }
        
        if ($updated->identity_attachment && $request->identity_attachment) {
            $updated->identity_attachment = Helper::updateUploadFile('centers/attachments', $request->identity_attachment, $updated->identity_attachment);
        } elseif ($request->identity_attachment) {
            $updated->identity_attachment = Helper::uploadFile('centers/attachments', $request->identity_attachment);
        }
        
        if ($updated->national_address && $request->national_address) {
            $updated->national_address = Helper::updateUploadFile('centers/attachments', $request->national_address, $updated->national_address);
        } elseif ($request->national_address) {
            $updated->national_address = Helper::uploadFile('centers/attachments', $request->national_address);
        }
        
        if ($updated->profile_attachment && $request->profile_attachment) {
            $updated->profile_attachment = Helper::updateUploadFile('centers/attachments', $request->profile_attachment, $updated->profile_attachment);
        } elseif ($request->profile_attachment) {
            $updated->profile_attachment = Helper::uploadFile('centers/attachments', $request->profile_attachment);
        }
        
        $updated->save();
        
        $responsibles_name =$request->responsible_name;
        if($responsibles_name){
            $responsibles_job=$request->responsible_job;
            $responsibles_email=$request->responsible_email;
            $responsibles_phone=$request->responsible_phone;
            $responsibles_whatsapp=$request->responsible_whatsapp;
            
            foreach($responsibles_name as $key=>$responsible_name){
                if($responsible_name && $responsibles_job[$key]){

                    $responsible = new CenterResponsible();
                    $responsible->center_id = $id;
                    $responsible->responsible_name = $responsible_name;
                    $responsible->responsible_job = $responsibles_job[$key];
                    $responsible->responsible_email = $responsibles_email[$key];
                    $responsible->responsible_phone = $responsibles_phone[$key];
                    $responsible->responsible_whatsapp = $responsibles_whatsapp[$key];
                    $responsible->created_by = auth()->user()->id;
                    $responsible->save();
                }
            }
        }

        toastr()->success(trans('home.your_item_updated_successfully'), trans('home.updated'));
        return redirect()->route('centers.index');
    }

     public function importExcel(Request $request)
    {
        if (empty($request->file('excelFile'))) {
            toastr()->error(trans('home.file_not_found'), trans('home.not_found'));
            return redirect()->back();
        }else{
            Excel::import(new CenterImport,$request->file('excelFile'));
            toastr()->success(trans('home.your_item_added_successfully'), trans('home.saved'));
            return redirect()->back();
        }
        
    }

    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            Center::destroy($id);
        }
    }
    
    public function delete_responsible_question(Request $request){
        CenterResponsible::findOrFail($request->responsible_id)->delete();
    }
    
    public function editresponsible(Request $request){
        $responsible = CenterResponsible::find($request->responsible_id);
        return response()->json(['view' => view('admin.centers.edit_responsible_modal', compact('responsible'))->render() ]);
    }
    
    public function viewresponsible(Request $request){
        $res = $request->responsible_id;
        $responsibles = CenterResponsible::where('center_id',$request->responsible_id)->get();
        return response()->json(['view' => view('admin.centers.view_responsible_modal', compact('responsibles','res'))->render()]);
    }
    
    public function updateResponsible(Request $request){
        $responsible = CenterResponsible::find($request->responsible_id);
        $responsible->responsible_name = $request->responsible_name;
        $responsible->responsible_job = $request->responsible_job;
        $responsible->responsible_email = $request->responsible_email;
        $responsible->responsible_phone = $request->responsible_phone;
        $responsible->responsible_whatsapp = $request->responsible_whatsapp;
        $responsible->updated_by = auth()->user()->id;
        $responsible->save();
         toastr()->success(trans('home.your_item_updated_successfully'), trans('home.updated'));
        return redirect()->route('centers.edit',$responsible->center_id);

    }
}
