<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\BlogItem;
use App\Models\BlogCategory;
use App\Models\Category;
use DB;
use File;
use Illuminate\Support\Facades\Input;
use Image;
use App\Models\Faq;
use App\Models\Writer;
use App\Helpers\Helper;
class BlogItemController extends Controller
{


    public function __construct()
    {
        $this->middleware('permission:blogItem');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $blogItems = BlogItem::orderBy('id','desc')->get();
        
        return view('admin.blogItems.blogItems',compact('blogItems'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $blogCourseCategories = Category::where('status',1)->get();
        $writers = Writer::where('status',1)->get();
        $blogCategories = BlogCategory::where('status',1)->get();
        return view('admin.blogItems.addBlogItem',compact('blogCategories','blogCourseCategories','writers'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        $blogitem = new BlogItem();
        $blogitem->name_en = $request->name_en;
        $blogitem->name_ar = $request->name_ar;
        $blogitem->blogcategory_id  = $request->blogcategory_id ;
        $blogitem->course_category_id  = $request->course_category_id ;
        $blogitem->link_en = str_replace(" ","-",$request->link_en);
        $blogitem->link_ar = str_replace(" ","-",$request->link_ar);
        $blogitem->date = $request->date;
        $blogitem->redirect_url = $request->redirect_url;
        $blogitem->alt_img = $request->alt_img;
        $blogitem->writer_id = $request->writer_id;
        $blogitem->text_source_en = $request->text_source_en;
        $blogitem->text_source_ar = $request->text_source_ar;
        $blogitem->status = $request->status;
        $blogitem->whatsapp = $request->whatsapp;
        $blogitem->mobile = $request->mobile;
        $blogitem->home = $request->home;
        $blogitem->text_en = $request->text_en;
        $blogitem->text_ar = $request->text_ar;
        $blogitem->meta_title_en = $request->meta_title_en;
        $blogitem->meta_title_ar = $request->meta_title_ar;
        $blogitem->meta_desc_en =$request->meta_desc_en;
        $blogitem->meta_desc_ar =$request->meta_desc_ar;
        $blogitem->meta_robots =$request->meta_robots;
        if($request->image){
            $blogitem->image = Helper::uploadImage('blogitems',$request->image);
        } 
        $blogitem->save();
        
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('blog-items.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $blogCourseCategories = Category::where('status',1)->get();
        $blogItem = BlogItem::find($id);
        if($blogItem){
            $blogCategories = BlogCategory::where('status',1)->get();
            $questions = Faq::where('type','blog_item')->where('blog_item_id',$id)->get();
            $writers = Writer::get();
            return view('admin.blogItems.editBlogItem',compact('blogCategories','blogCourseCategories','blogItem','questions','writers'));
        }else{
            abort('404');
        }
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $blogitem = BlogItem::find($id);
        $blogitem->name_en = $request->name_en;
        $blogitem->name_ar = $request->name_ar;
        $blogitem->blogcategory_id = $request->blogcategory_id;
        $blogitem->course_category_id = $request->course_category_id;
        $blogitem->link_en = str_replace(" ","-",$request->link_en);
        $blogitem->link_ar = str_replace(" ","-",$request->link_ar);
        $blogitem->date = $request->date;
        $blogitem->alt_img = $request->alt_img;
        $blogitem->writer_id = $request->writer_id;
        $blogitem->status = $request->status;
        $blogitem->whatsapp = $request->whatsapp;
        $blogitem->mobile = $request->mobile;
        $blogitem->redirect_url = $request->redirect_url;
        $blogitem->home = $request->home;
        $blogitem->text_en = $request->text_en;
        $blogitem->text_ar = $request->text_ar;
        $blogitem->text_source_en = $request->text_source_en;
        $blogitem->text_source_ar = $request->text_source_ar;
        $blogitem->meta_title_en = $request->meta_title_en;
        $blogitem->meta_title_ar = $request->meta_title_ar;
        $blogitem->meta_desc_en =$request->meta_desc_en;
        $blogitem->meta_desc_ar =$request->meta_desc_ar;
        $blogitem->meta_robots =$request->meta_robots;
        if($blogitem->image && $request->image){
            $blogitem->image = Helper::updateUploadedImage('blogitems',$request->image ,$blogitem->image);
        }elseif($request->image){
            $blogitem->image = Helper::uploadImage('blogitems',$request->image);
        } 
        $blogitem->save();
        
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return redirect()->route('blog-items.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids){
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        $img_path = base_path() . '/uploads/blogitems/';
        if($allElements){
            foreach ($ids as $id) {
                $blogitem = BlogItem::findOrFail($id);
                Faq::where('type','blog_item')->where('blog_item_id',$id)->delete();
                
                if ($blogitem->image) {
                    (file_exists(sprintf($img_path . '%s', $blogitem->image)))?unlink(sprintf($img_path . '%s', $blogitem->image)):'';
                }
            }
            BlogItem::truncate();
            
        }else{
        
            foreach ($ids as $id) {
                $blogitem = BlogItem::findOrFail($id);
                Faq::where('type','blog_item')->where('blog_item_id',$id)->delete();
                if ($blogitem->image) {
                    (file_exists(sprintf($img_path . '%s', $blogitem->image)))?unlink(sprintf($img_path . '%s', $blogitem->image)):'';
                }
                $blogitem->delete();
            }
        }
    }
    
    public function storeFaq(Request $request){
        $faq= new Faq();
        $faq->question_en = $request->question_en;
        $faq->answer_en = $request->answer_en;
        $faq->question_ar = $request->question_ar;
        $faq->answer_ar = $request->answer_ar;
        $faq->type = 'blog_item';
        $faq->blog_item_id = $request->blog_item_id;
        $faq->save();
        
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return back();
    }

    public function updateFaq(Request $request){
        $faq=Faq::find($request->faq_id);
        $faq->question_en = $request->question_en;
        $faq->answer_en = $request->answer_en;
        $faq->question_ar = $request->question_ar;
        $faq->answer_ar = $request->answer_ar;
        $faq->save();
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return back();
    }
    
    public function removeFaq(){
        $faqId= $_POST['faq_id'];
        Faq::find($faqId)->delete();
    }
}
