<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Cart;
use App\Models\CartCourse;
use App\Models\GuestCart;
use App\Models\GuestCartCourse;
use App\Models\GuestWishlist;
use App\Models\OrderCourse;
use App\Models\Wishlist;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

use Illuminate\Http\Request;
use Auth;
use App\Vendor;
use Laravel\Socialite\Facades\Socialite;
use App\User;
use Redirect;
use Mail;
use Session;
class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/admin';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    

    use AuthenticatesUsers {
        logout as performLogout;
    }

    public function logout(Request $request){
        $this->performLogout($request);
        return redirect('/');
    }

    public function redirectToFacebookProvider(){
        return Socialite::driver('facebook ')->redirect();
    }

    public function handleFacebookProviderCallback(Request $request){
        try {

            if (!$request->has('code') || $request->has('denied')) {
                return redirect('/');
            }

            $userSocial = Socialite::driver('facebook')->user();
            $chars = array(0,1,2,3,4,5,6,7,8,9,'A','B','C','D','E','F','G');
            $password = '';
            $max = count($chars)-1;
            for($i=0;$i<8;$i++){
                $password .= (!($i % 5) && $i ? '-' : '').$chars[rand(0, $max)];
            }

            $findUser=User::where('email',$userSocial->email)->first();

            if($findUser){
                Auth::loginUsingId($findUser->id);
                return Redirect::intended($this->redirectPath('/'));
            }else{

                $user= new User();
                $user->f_name=$userSocial->name;
                $user->l_name=$userSocial->name;
                $user->email=$userSocial->email;
                $user->password=bcrypt($password);
                $user->facebook_id=$userSocial->getId();
                // $user->email_verified_at = date('Format String');
                $user->save();
                Auth::loginUsingId($user->id);
                return Redirect::intended($this->redirectPath('/'));

            }
            return redirect('/');
        } catch (Exception $e) {
            return redirect ('/');
        }
    }


    public function redirectToGoogleProvider(){
        return Socialite::driver('google')->redirect();
    }

    public function handleGoogleProviderCallback(){
        try{

            $userSocial = Socialite::driver('google')->user();
            $chars = array(0,1,2,3,4,5,6,7,8,9,'A','B','C','D','E','F','G');
            $password = '';
            $max = count($chars)-1;
            for($i=0;$i<8;$i++){
                $password .= (!($i % 5) && $i ? '-' : '').$chars[rand(0, $max)];
            }

            $findUser=User::where('email',$userSocial->email)->first();

            //dd($findUser);
            if($findUser){
                //Auth::loginUsingId($findUser->id);
                Auth::login($findUser);
                return Redirect::intended($this->redirectPath('/'));
            }else{
                $user= new User();
                $user->f_name=$userSocial->user['given_name'];
                $user->l_name=$userSocial->user['family_name'];
                $user->email=$userSocial->email;
                $user->password=bcrypt($password);
                $user->google_id=$userSocial->getId();
                // $user->email_verified_at = date('Format String');
                $user->save();
                //Auth::loginUsingId($user->id);
                Auth::login($user);
            }
            return redirect('/');

        } catch (Exception $e) {
            return redirect ('/');
        }
    }

    public function login(Request $request){
        $this->validateLogin($request);

        $loginType = filter_var($request->input('email'), FILTER_VALIDATE_EMAIL) ? 'email' : 'phone';
        $credentials = [
            $loginType => $request->input('email'),
            'password' => $request->input('password'),
        ];
        // dd($credentials);
        if (auth()->attempt($credentials)) {
            // Perform guest cart and wishlist operations
            $this->guestOperations();
    
            // Get the authenticated user
            $user = auth()->user();
        
            // Redirect based on user type
            if ($user->type === 'admin') {
                return redirect()->route('admin'); // Replace with actual admin route
            } elseif ($user->type === 'crm_employee') {
                return redirect()->route('crmHome'); // Replace with CRM dashboard route
            }
    
            // Default login response
            return $this->sendLoginResponse($request);
        }else{
            return back()->With('error','البيانات غير صحيحة');
        }

        return $this->sendFailedLoginResponse($request);
    }

    public function guestOperations(){
     

        //////// add guest cart ///////
        if(Session::has('session_id')){
            $session_id = Session::get('session_id');
            
            
            //////// Wishlist ///////
            $guest_wishlist_course_ids = GuestWishlist::where('session_id',$session_id)->pluck('course_id')->toArray();
            foreach($guest_wishlist_course_ids as $course_wish_id ){
                Wishlist::updateOrCreate([
                    'user_id'=>auth()->user()->id,
                    'course_id'=>$course_wish_id,
                ]);
            }
            GuestWishlist::where('session_id',$session_id)->delete();
            
            //////// Cart ///////

            $guestCart = GuestCart::where('session_id',$session_id)->first();
            $cartCourses = GuestCartCourse::where('guest_cart_id',$guestCart->id)->get();
            $amount = 0;

            $cart=Cart::where('user_id',Auth::user()->id)->first();
            if(!$cart){
                // /////create user cart///
                $cart= new Cart();
                $cart->user_id=Auth::user()->id;
                $cart->coupon_id = null;
                $cart->coupon_discount = null;
                $cart->total_price = 0;
                $cart->save();
            }

            foreach($cartCourses as $cartCourse){

                $check_cartCourse=CartCourse::where('course_id',$cartCourse->course_id)->where('cart_id',$cart->id)->orderBy('id','desc')->first();
                $orderCourse=OrderCourse::where('course_id',$cartCourse->course_id)->where('user_id',Auth::user()->id)->first();

                if(!$check_cartCourse &&!$orderCourse){
                    //////ADD CART course ////////
                    $add= new CartCourse();
                    $add->cart_id=$cart->id;
                    $add->course_id=$cartCourse->course_id;
                    $add->price=$cartCourse->price;
                    $add->price_before_discount=$cartCourse->price_before_discount;
                    $add->save();
                    $amount += $cartCourse->price;
                }
            }
            $cart->total_price += $amount;
            $cart->save();

            // ////// delete guest cart////
            $guestCart->delete();
            Session::forget('session_id');
        }
    }



}
