<?php

namespace App\Helpers;
use App\Models\Cart;
use App\Models\GuestCart;
use Illuminate\Support\Facades\Auth;
use Session;
use File;
use Image;


class Helper
{
    public static function cssFilesPath(string $string){
        return url('resources/assets/front/css/'.$string);
    }

    public static function jsFilesPath(string $string){
        return url('resources/assets/front/js/'.$string);
    }

    public static function imageFilesPath(string $string){
        return url('resources/assets/front/images/'.$string);
    }

    public static function uploadedImagesPath($model,$image){
        return url('uploads/'.$model.'/'.$image, false);
    }
    public static function uploadedFilesPath($model,$file){
        return url('uploads/'.$model.'/source/'.$file, false);
    }
    public static function uploadedAttachmentPath($file){
        return url('uploads/attachments/source/'.$file);
    }
    public static function uploadedSliderImagesPath($model,$image){
        return url('uploads/sliders/'.$model.'/'.$image);
    }


    public static function uploadImage($model,$image){
        if ($image) {
            $mime = File::mimeType($image);
            $mimearr = explode('/', $mime);
            
            if (!in_array($mimearr[1], ['jpeg', 'png', 'gif', 'bmp', 'webp'])) {
                // Handle unsupported file type, e.g., throw an exception or return an error message
                throw new \Exception("Unsupported image type: $mime. Only JPG, PNG, GIF, BMP, and WebP are supported.");
            }
            $directory = base_path("uploads/$model");
            if (!File::exists($directory)) {
                File::makeDirectory($directory, true); // Create directory with permissions
            }
                
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path("uploads/$model/$fileName");
            Image::make($image->getRealPath())->save($path);   
            return $fileName; 
        }else{
            return NULL;
        }
    } 

    public static function updateUploadedImage($model,$image,$oldImage){
        if ($image) {
            ///////remove the old image///////
             if (file_exists($oldImage)) {
                $img_path = base_path() . "/uploads/$model/";
                (file_exists(sprintf($img_path . '%s', $oldImage)))?unlink(sprintf($img_path . '%s', $oldImage)):'';
            }
            $directory = base_path("uploads/$model");
            if (!File::exists($directory)) {
                File::makeDirectory($directory, true); 
            }
            
            $mime = File::mimeType($image);
            $mimearr = explode('/', $mime);
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path("uploads/$model/$fileName");
            Image::make($image->getRealPath())->save($path);    
            return $fileName;
        }else{
            return NULL;
        }
    } 
    
    public static function updateUploadedFile($model,$file,$oldFile){
        if ($file) {
            ///////remove the old file///////
            if (file_exists($oldFile)) {
                $file_path = base_path() . "/uploads/$model/source/";
                (file_exists(sprintf($file_path . '%s', $oldFile)))?unlink(sprintf($file_path . '%s', $oldFile)):'';
            }
            $directory = base_path("uploads/$model");
            if (!File::exists($directory)) {
                File::makeDirectory($directory, true); // Create directory with permissions
            }
            
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path("uploads/$model/source/");
            $file->move( $path, $fileName );   
            return $fileName;
        }else{
            return NULL;
        }
    } 
    
    

    public static function uploadFile($model,$file){
        if ($file) {
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path("uploads/$model/source/");
            $file->move( $path, $fileName );
            return $fileName;
        }else{
            return NULL;
        }
    } 

        public static function uploadAttendanceFile($model, $file, $training_code){
            if ($file) {
                $extension = $file->getClientOriginalExtension(); 
                $name = $file->getClientOriginalName(); 
                $fileName = 'training-'.$training_code.'-'. date('Y-m-d').'-' . $name . time() . '.' . $extension; 
                $path = base_path("uploads/$model/");
                $file->move($path, $fileName);
                return $fileName;
            } else {
                return null;
            }
        }


    public static function resetCart(){
        if(Auth::check()){
            $cart=Cart::with('cart_courses')->where('user_id',auth()->user()->id)->first();
        }else{
            return route('login');
        }
        
        $total_price = 0;
        if($cart){
            $total_price = $cart->cart_courses->map(function($cart_course) {
                return $cart_course->Course->last_price();
            })->sum();
            $cart->total_price=$total_price;
            $cart->coupon_id=null;
            $cart->coupon_discount=null;
            $cart->save();
        }
    } 



}
